/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Pulleys
extends TestbedTest {
    private static final long JOINT_TAG = 2L;
    PulleyJoint m_joint1;

    @Override
    public Long getTag(Joint joint) {
        if (joint == this.m_joint1) {
            return 2L;
        }
        return super.getTag(joint);
    }

    @Override
    public void processJoint(Joint joint, Long tag) {
        if (tag == 2L) {
            this.m_joint1 = (PulleyJoint)joint;
        } else {
            super.processJoint(joint, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        double y = 16.0;
        double L = 12.0;
        double a = 1.0;
        double b = 2.0;
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        CircleShape circle = new CircleShape();
        circle.m_radius = 2.0;
        circle.m_p.set(-10.0, y + b + L);
        ground.createFixture((Shape)circle, 0.0);
        circle.m_p.set(10.0, y + b + L);
        ground.createFixture((Shape)circle, 0.0);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(a, b);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(-10.0, y);
        Body body1 = this.getWorld().createBody(bd2);
        body1.createFixture((Shape)shape2, 5.0);
        bd2.position.set(10.0, y);
        Body body2 = this.getWorld().createBody(bd2);
        body2.createFixture((Shape)shape2, 5.0);
        PulleyJointDef pulleyDef = new PulleyJointDef();
        Vec2 anchor1 = new Vec2(-10.0, y + b);
        Vec2 anchor2 = new Vec2(10.0, y + b);
        Vec2 groundAnchor1 = new Vec2(-10.0, y + b + L);
        Vec2 groundAnchor2 = new Vec2(10.0, y + b + L);
        pulleyDef.initialize(body1, body2, groundAnchor1, groundAnchor2, anchor1, anchor2, 2.0);
        this.m_joint1 = (PulleyJoint)this.getWorld().createJoint((JointDef)pulleyDef);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        double ratio = this.m_joint1.getRatio();
        double L = this.m_joint1.getLength1() + ratio * this.m_joint1.getLength2();
        this.addTextLine("L1 + " + ratio + " * L2 = " + L);
        if (L >= 36.0) {
            this.addTextLine("Pulley is taught");
        }
    }

    @Override
    public String getTestName() {
        return "Pulleys";
    }
}

