/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class PrismaticTest
extends TestbedTest {
    private static final long JOINT_TAG = 1L;
    PrismaticJoint m_joint;

    @Override
    public Long getTag(Joint joint) {
        if (joint == this.m_joint) {
            return 1L;
        }
        return super.getTag(joint);
    }

    @Override
    public void processJoint(Joint joint, Long tag) {
        if (tag == 1L) {
            this.m_joint = (PrismaticJoint)joint;
        } else {
            super.processJoint(joint, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(2.0, 0.5);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(-10.0, 10.0);
        bd2.angle = 1.5707963267948966;
        bd2.allowSleep = false;
        Body body = this.getWorld().createBody(bd2);
        body.createFixture((Shape)shape2, 5.0);
        PrismaticJointDef pjd = new PrismaticJointDef();
        Vec2 axis = new Vec2(2.0, 1.0);
        axis.normalize();
        pjd.initialize(ground, body, new Vec2(0.0, 0.0), axis);
        pjd.motorSpeed = 10.0;
        pjd.maxMotorForce = 10000.0;
        pjd.enableMotor = true;
        pjd.lowerTranslation = 0.0;
        pjd.upperTranslation = 20.0;
        pjd.enableLimit = true;
        this.m_joint = (PrismaticJoint)this.getWorld().createJoint((JointDef)pjd);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (l) limits, (m) motors, (s) speed");
        double force = this.m_joint.getMotorForce(1.0);
        this.addTextLine("Motor Force = " + force);
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'l': {
                this.m_joint.enableLimit(!this.m_joint.isLimitEnabled());
                this.getModel().getKeys()[108] = false;
                break;
            }
            case 'm': {
                this.m_joint.enableMotor(!this.m_joint.isMotorEnabled());
                this.getModel().getKeys()[109] = false;
                break;
            }
            case 's': {
                this.m_joint.setMotorSpeed(-this.m_joint.getMotorSpeed());
                this.getModel().getKeys()[115] = false;
            }
        }
    }

    @Override
    public String getTestName() {
        return "Prismatic";
    }
}

