/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.pooling.IWorldPool;

class PolyShapesCallback
implements QueryCallback {
    int e_maxCount = 30;
    CircleShape m_circle = new CircleShape();
    Transform m_transform = new Transform();
    DebugDraw debugDraw;
    int m_count = 0;
    IWorldPool p;

    public PolyShapesCallback(IWorldPool argWorld) {
        this.p = argWorld;
    }

    void DrawFixture(Fixture fixture) {
        Color3f color = new Color3f((double)0.95f, (double)0.95f, (double)0.6f);
        Transform xf = fixture.getBody().getTransform();
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circle = (CircleShape)fixture.getShape();
                Vec2 center = Transform.mul((Transform)xf, (Vec2)circle.m_p);
                double radius = circle.m_radius;
                this.debugDraw.drawCircle(center, radius, color);
                break;
            }
            case POLYGON: {
                PolygonShape poly = (PolygonShape)fixture.getShape();
                int vertexCount = poly.m_count;
                assert (vertexCount <= Settings.maxPolygonVertices);
                Vec2[] vertices = new Vec2[Settings.maxPolygonVertices];
                for (int i = 0; i < vertexCount; ++i) {
                    vertices[i] = Transform.mul((Transform)xf, (Vec2)poly.m_vertices[i]);
                }
                this.debugDraw.drawPolygon(vertices, vertexCount, color);
                break;
            }
        }
    }

    public boolean reportFixture(Fixture fixture) {
        if (this.m_count == this.e_maxCount) {
            return false;
        }
        Body body = fixture.getBody();
        Shape shape = fixture.getShape();
        boolean overlap = this.p.getCollision().testOverlap(shape, 0, (Shape)this.m_circle, 0, body.getTransform(), this.m_transform);
        if (overlap) {
            this.DrawFixture(fixture);
            ++this.m_count;
        }
        return true;
    }
}

