/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.tests.PolyShapesCallback;

public class PolyShapes
extends TestbedTest {
    int k_maxBodies = 256;
    int m_bodyIndex;
    Body[] m_bodies = new Body[this.k_maxBodies];
    PolygonShape[] m_polygons = new PolygonShape[4];
    CircleShape m_circle;

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        Vec2[] vertices = new Vec2[]{new Vec2(-0.5, 0.0), new Vec2(0.5, 0.0), new Vec2(0.0, 1.5)};
        this.m_polygons[0] = new PolygonShape();
        this.m_polygons[0].set(vertices, 3);
        vertices = new Vec2[]{new Vec2((double)-0.1f, 0.0), new Vec2((double)0.1f, 0.0), new Vec2(0.0, 1.5)};
        this.m_polygons[1] = new PolygonShape();
        this.m_polygons[1].set(vertices, 3);
        double w = 1.0;
        double b = w / (2.0 + MathUtils.sqrt((double)2.0));
        double s = MathUtils.sqrt((double)2.0) * b;
        Vec2[] vertices2 = new Vec2[]{new Vec2(0.5 * s, 0.0), new Vec2(0.5 * w, b), new Vec2(0.5 * w, b + s), new Vec2(0.5 * s, w), new Vec2(-0.5 * s, w), new Vec2(-0.5 * w, b + s), new Vec2(-0.5 * w, b), new Vec2(-0.5 * s, 0.0)};
        this.m_polygons[2] = new PolygonShape();
        this.m_polygons[2].set(vertices2, 8);
        this.m_polygons[3] = new PolygonShape();
        this.m_polygons[3].setAsBox(0.5, 0.5);
        this.m_circle = new CircleShape();
        this.m_circle.m_radius = 0.5;
        this.m_bodyIndex = 0;
    }

    void Create(int index) {
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        double x = MathUtils.randomDouble((double)-2.0, (double)2.0);
        bd.position.set(x, 10.0);
        bd.angle = MathUtils.randomDouble((double)(-Math.PI), (double)Math.PI);
        if (index == 4) {
            bd.angularDamping = 0.02f;
        }
        this.m_bodies[this.m_bodyIndex] = this.getWorld().createBody(bd);
        if (index < 4) {
            FixtureDef fd = new FixtureDef();
            fd.shape = this.m_polygons[index];
            fd.density = 1.0;
            fd.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fd);
        } else {
            FixtureDef fd = new FixtureDef();
            fd.shape = this.m_circle;
            fd.density = 1.0;
            fd.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fd);
        }
        this.m_bodyIndex = (this.m_bodyIndex + 1) % this.k_maxBodies;
    }

    void DestroyBody() {
        for (int i = 0; i < this.k_maxBodies; ++i) {
            if (this.m_bodies[i] == null) continue;
            this.getWorld().destroyBody(this.m_bodies[i]);
            this.m_bodies[i] = null;
            return;
        }
    }

    @Override
    public void keyPressed(char key, int argKeyCode) {
        switch (key) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                this.Create(key - 49);
                break;
            }
            case 'a': {
                for (int i = 0; i < this.k_maxBodies; i += 2) {
                    if (this.m_bodies[i] == null) continue;
                    boolean active = this.m_bodies[i].isActive();
                    this.m_bodies[i].setActive(!active);
                }
                break;
            }
            case 'd': {
                this.DestroyBody();
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        PolyShapesCallback callback = new PolyShapesCallback(this.getWorld().getPool());
        callback.m_circle.m_radius = 2.0;
        callback.m_circle.m_p.set(0.0, (double)2.1f);
        callback.m_transform.setIdentity();
        callback.debugDraw = this.getDebugDraw();
        AABB aabb = new AABB();
        callback.m_circle.computeAABB(aabb, callback.m_transform, 0);
        this.getWorld().queryAABB((QueryCallback)callback, aabb);
        Color3f color = new Color3f((double)0.4f, (double)0.7f, (double)0.8f);
        this.getDebugDraw().drawCircle(callback.m_circle.m_p, callback.m_circle.m_radius, color);
        this.addTextLine("Press 1-5 to drop stuff");
        this.addTextLine("Press 'a' to (de)activate some bodies");
        this.addTextLine("Press 'd' to destroy a body");
        this.addTextLine("Up to 30 bodies in the target circle are highlighted");
    }

    @Override
    public String getTestName() {
        return "PolyShapes";
    }
}

