/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class PistonTest
extends TestbedTest {
    private boolean bullet = false;

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        Body body;
        if (deserialized) {
            return;
        }
        World world = this.getWorld();
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(5.0, 100.0);
        bd = new BodyDef();
        bd.type = BodyType.STATIC;
        FixtureDef sides = new FixtureDef();
        sides.shape = shape;
        sides.density = 0.0;
        sides.friction = 0.0;
        sides.restitution = 0.8f;
        sides.filter.categoryBits = 4;
        sides.filter.maskBits = 2;
        bd.position.set((double)-10.01f, 50.0);
        Body bod = world.createBody(bd);
        bod.createFixture(sides);
        bd.position.set((double)10.01f, 50.0);
        bod = world.createBody(bd);
        bod.createFixture(sides);
        FixtureDef fd = new FixtureDef();
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        int numPieces = 5;
        double radius = 4.0;
        bd2.position = new Vec2(0.0, 25.0);
        Body body2 = this.getWorld().createBody(bd2);
        for (int i = 0; i < numPieces; ++i) {
            CircleShape cd = new CircleShape();
            cd.m_radius = 0.5;
            fd.shape = cd;
            fd.density = 25.0;
            fd.friction = 0.1f;
            fd.restitution = 0.9f;
            double xPos = radius * Math.cos(Math.PI * 2 * ((double)i / (double)numPieces));
            double yPos = radius * Math.sin(Math.PI * 2 * ((double)i / (double)numPieces));
            cd.m_p.set(xPos, yPos);
            body2.createFixture(fd);
        }
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(body2, this.getGroundBody(), body2.getPosition());
        rjd.motorSpeed = Math.PI;
        rjd.maxMotorTorque = 1000000.0;
        rjd.enableMotor = true;
        this.getWorld().createJoint((JointDef)rjd);
        Body prevBody = ground;
        shape = new PolygonShape();
        shape.setAsBox(0.5, 2.0);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0, 7.0);
        Body body3 = this.getWorld().createBody(bd2);
        body3.createFixture((Shape)shape, 2.0);
        RevoluteJointDef rjd2 = new RevoluteJointDef();
        rjd2.initialize(prevBody, body3, new Vec2(0.0, 5.0));
        rjd2.motorSpeed = Math.PI;
        rjd2.maxMotorTorque = 20000.0;
        rjd2.enableMotor = true;
        this.getWorld().createJoint((JointDef)rjd2);
        prevBody = body3;
        shape = new PolygonShape();
        shape.setAsBox(0.5, 4.0);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0, 13.0);
        body3 = this.getWorld().createBody(bd2);
        body3.createFixture((Shape)shape, 2.0);
        rjd2 = new RevoluteJointDef();
        rjd2.initialize(prevBody, body3, new Vec2(0.0, 9.0));
        rjd2.enableMotor = false;
        this.getWorld().createJoint((JointDef)rjd2);
        prevBody = body3;
        shape = new PolygonShape();
        shape.setAsBox(7.0, 2.0);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0, 17.0);
        body3 = this.getWorld().createBody(bd2);
        FixtureDef piston = new FixtureDef();
        piston.shape = shape;
        piston.density = 2.0;
        piston.filter.categoryBits = 1;
        piston.filter.maskBits = 2;
        body3.createFixture(piston);
        body3.setBullet(false);
        RevoluteJointDef rjd3 = new RevoluteJointDef();
        rjd3.initialize(prevBody, body3, new Vec2(0.0, 17.0));
        this.getWorld().createJoint((JointDef)rjd3);
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(ground, body3, new Vec2(0.0, 17.0), new Vec2(0.0, 1.0));
        pjd.maxMotorForce = 1000.0;
        pjd.enableMotor = true;
        this.getWorld().createJoint((JointDef)pjd);
        PolygonShape sd = new PolygonShape();
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        FixtureDef fixture = new FixtureDef();
        for (int i = 0; i < 100; ++i) {
            sd.setAsBox((double)0.4f, (double)0.3f);
            bd2.position.set(-1.0, (double)(23.0f + (float)i));
            bd2.bullet = this.bullet;
            body = world.createBody(bd2);
            fixture.shape = sd;
            fixture.density = 0.1f;
            fixture.filter.categoryBits = 2;
            fixture.filter.maskBits = 7;
            body.createFixture(fixture);
        }
        CircleShape cd = new CircleShape();
        cd.m_radius = 0.36f;
        for (int i = 0; i < 100; ++i) {
            bd2.position.set(1.0, (double)(23.0f + (float)i));
            bd2.bullet = this.bullet;
            fixture.shape = cd;
            fixture.density = 2.0;
            fixture.filter.categoryBits = 2;
            fixture.filter.maskBits = 7;
            body = world.createBody(bd2);
            body.createFixture(fixture);
        }
        double angle = 0.0;
        double delta = 1.0471975511965976;
        Vec2[] vertices = new Vec2[6];
        for (int i = 0; i < 6; ++i) {
            vertices[i] = new Vec2((double)0.3f * MathUtils.cos((double)angle), (double)0.3f * MathUtils.sin((double)angle));
            angle += delta;
        }
        PolygonShape shape2 = new PolygonShape();
        shape2.set(vertices, 6);
        for (int i = 0; i < 100; ++i) {
            bd2.position.set(0.0, (double)(23.0f + (float)i));
            bd2.type = BodyType.DYNAMIC;
            bd2.fixedRotation = true;
            bd2.bullet = this.bullet;
            fixture.shape = shape2;
            fixture.density = 1.0;
            fixture.filter.categoryBits = 2;
            fixture.filter.maskBits = 7;
            body = world.createBody(bd2);
            body.createFixture(fixture);
        }
    }

    @Override
    public String getTestName() {
        return "Piston Stress Test";
    }
}

