/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ParticleTypes
extends TestbedTest {
    Body circle;
    int flags = 128;

    @Override
    public void initTest(boolean deserialized) {
        Body body;
        BodyDef bd = new BodyDef();
        Body ground = this.m_world.createBody(bd);
        PolygonShape shape = new PolygonShape();
        Vec2[] vertices = new Vec2[]{new Vec2(-40.0, -10.0), new Vec2(40.0, -10.0), new Vec2(40.0, 0.0), new Vec2(-40.0, 0.0)};
        shape.set(vertices, 4);
        ground.createFixture((Shape)shape, 0.0);
        shape = new PolygonShape();
        vertices = new Vec2[]{new Vec2(-40.0, -1.0), new Vec2(-20.0, -1.0), new Vec2(-20.0, 20.0), new Vec2(-40.0, 30.0)};
        shape.set(vertices, 4);
        ground.createFixture((Shape)shape, 0.0);
        shape = new PolygonShape();
        vertices = new Vec2[]{new Vec2(20.0, -1.0), new Vec2(40.0, -1.0), new Vec2(40.0, 30.0), new Vec2(20.0, 20.0)};
        shape.set(vertices, 4);
        ground.createFixture((Shape)shape, 0.0);
        this.m_world.setParticleRadius((double)0.2f);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(20.0, 10.0, new Vec2(0.0, 10.0), 0.0);
        ParticleGroupDef pd = new ParticleGroupDef();
        pd.flags = pd.flags;
        pd.shape = shape2;
        this.m_world.createParticleGroup(pd);
        bd = new BodyDef();
        bd.type = BodyType.KINEMATIC;
        this.circle = body = this.m_world.createBody(bd);
        shape = new CircleShape();
        shape.m_p.set(0.0, 5.0);
        shape.m_radius = 1.0;
        body.createFixture((Shape)shape, (double)0.1f);
        body.setLinearVelocity(new Vec2(-6.0, 0.0));
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        body = this.m_world.createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(1.0, 1.0, new Vec2(-10.0, 5.0), 0.0);
        body.createFixture((Shape)shape, (double)0.1f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        body = this.m_world.createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(1.0, 1.0, new Vec2(10.0, 5.0), 0.5);
        body.createFixture((Shape)shape, (double)0.1f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        body = this.m_world.createBody(bd);
        shape = new EdgeShape();
        shape.set(new Vec2(0.0, 20.0), new Vec2(1.0, 21.0));
        body.createFixture((Shape)shape, (double)0.1f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        body = this.m_world.createBody(bd);
        shape = new EdgeShape();
        shape.set(new Vec2(3.0, 20.0), new Vec2(4.0, 21.0));
        body.createFixture((Shape)shape, (double)0.1f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        body = this.m_world.createBody(bd);
        shape = new EdgeShape();
        shape.set(new Vec2(-3.0, 21.0), new Vec2(-2.0, 20.0));
        body.createFixture((Shape)shape, (double)0.1f);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        Vec2 p = this.circle.getTransform().p;
        Vec2 v = this.circle.getLinearVelocity();
        if (p.x < -10.0 && v.x < 0.0 || p.x > 10.0 && v.x > 0.0) {
            v.x = -v.x;
            this.circle.setLinearVelocity(v);
        }
        int[] flagsBuffer = this.m_world.getParticleFlagsBuffer();
        for (int i = 0; i < this.m_world.getParticleCount(); ++i) {
            flagsBuffer[i] = this.flags;
        }
        this.addTextLine("'a' Clear");
        this.addTextLine("'e' Elastic " + ((this.flags & 0x10) != 0));
        this.addTextLine("'q' Powder  " + ((this.flags & 0x40) != 0));
        this.addTextLine("'t' Tensile " + ((this.flags & 0x80) != 0));
        this.addTextLine("'v' Viscous " + ((this.flags & 0x20) != 0));
    }

    @Override
    public void keyPressed(char keyCar, int keyCode) {
        super.keyPressed(keyCar, keyCode);
        int toggle = 0;
        switch (keyCar) {
            case 'a': {
                this.flags = 0;
                break;
            }
            case 'e': {
                toggle = 16;
                break;
            }
            case 'q': {
                toggle = 64;
                break;
            }
            case 't': {
                toggle = 128;
                break;
            }
            case 'v': {
                toggle = 32;
            }
        }
        if (toggle != 0) {
            this.flags = (this.flags & toggle) != 0 ? (this.flags &= ~toggle) : (this.flags |= toggle);
        }
    }

    @Override
    public String getTestName() {
        return "ParticleTypes";
    }
}

