/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedTest;

public class OneSidedTest
extends TestbedTest {
    private static final long PLATFORM_TAG = 10L;
    private static final long CHARACTER_TAG = 11L;
    double m_radius;
    double m_top;
    double m_bottom;
    State m_state;
    Fixture m_platform;
    Fixture m_character;

    @Override
    public Long getTag(Fixture fixture) {
        if (fixture == this.m_platform) {
            return 10L;
        }
        if (fixture == this.m_character) {
            return 11L;
        }
        return super.getTag(fixture);
    }

    @Override
    public void processFixture(Fixture fixture, Long tag) {
        if (tag == 10L) {
            this.m_platform = fixture;
        } else if (tag == 11L) {
            this.m_character = fixture;
        } else {
            super.processFixture(fixture, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public String getTestName() {
        return "One Sided";
    }

    @Override
    public void initTest(boolean deserialized) {
        this.m_state = State.e_unknown;
        if (deserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-20.0, 0.0), new Vec2(20.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        bd = new BodyDef();
        bd.position.set(0.0, 10.0);
        Body body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(3.0, 0.5);
        this.m_platform = body.createFixture((Shape)shape, 0.0);
        this.m_bottom = 9.5;
        this.m_top = 10.5;
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 12.0);
        body = this.getWorld().createBody(bd);
        this.m_radius = 0.5;
        shape = new CircleShape();
        shape.m_radius = this.m_radius;
        this.m_character = body.createFixture((Shape)shape, 20.0);
        body.setLinearVelocity(new Vec2(0.0, -50.0));
        this.m_state = State.e_unknown;
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        super.preSolve(contact, oldManifold);
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (fixtureA != this.m_platform && fixtureA != this.m_character) {
            return;
        }
        if (fixtureB != this.m_character && fixtureB != this.m_character) {
            return;
        }
        Vec2 position = this.m_character.getBody().getPosition();
        if (position.y < this.m_top + this.m_radius - 3.0 * Settings.linearSlop) {
            contact.setEnabled(false);
        }
    }

    static enum State {
        e_unknown,
        e_above,
        e_below;

    }
}

