/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.MotorJoint;
import org.jbox2d.dynamics.joints.MotorJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class MotorTest
extends TestbedTest {
    MotorJoint m_joint;
    double m_time;
    boolean m_go;
    Vec2 linearOffset = new Vec2();
    Color3f color = new Color3f((double)0.9f, (double)0.9f, (double)0.9f);

    @Override
    public void initTest(boolean deserialized) {
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-20.0, 0.0), new Vec2(20.0, 0.0));
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        this.getGroundBody().createFixture(fd);
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 8.0);
        Body body = this.getWorld().createBody(bd);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(2.0, 0.5);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = shape2;
        fd2.friction = 0.6f;
        fd2.density = 2.0;
        body.createFixture(fd2);
        MotorJointDef mjd = new MotorJointDef();
        mjd.initialize(this.getGroundBody(), body);
        mjd.maxForce = 1000.0;
        mjd.maxTorque = 1000.0;
        this.m_joint = (MotorJoint)this.m_world.createJoint((JointDef)mjd);
        this.m_go = false;
        this.m_time = 0.0;
    }

    @Override
    public void keyPressed(char keyCar, int keyCode) {
        super.keyPressed(keyCar, keyCode);
        switch (keyCar) {
            case 's': {
                this.m_go = !this.m_go;
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        double hz = settings.getSetting((String)"Hz").value;
        if (this.m_go && hz > 0.0) {
            this.m_time += 1.0 / hz;
        }
        this.linearOffset.x = 6.0 * MathUtils.sin((double)(2.0 * this.m_time));
        this.linearOffset.y = 8.0 + 4.0 * MathUtils.sin((double)(1.0 * this.m_time));
        double angularOffset = 4.0 * this.m_time;
        this.m_joint.setLinearOffset(this.linearOffset);
        this.m_joint.setAngularOffset(angularOffset);
        this.getDebugDraw().drawPoint(this.linearOffset, 4.0, this.color);
        super.step(settings);
        this.addTextLine("Keys: (s) pause");
    }

    @Override
    public String getTestName() {
        return "Motor Joint";
    }
}

