/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Gears
extends TestbedTest {
    RevoluteJoint m_joint1;
    RevoluteJoint m_joint2;
    PrismaticJoint m_joint3;
    GearJoint m_joint4;
    GearJoint m_joint5;

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(50.0, 0.0), new Vec2(-50.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        CircleShape circle1 = new CircleShape();
        circle1.m_radius = 1.0;
        PolygonShape box = new PolygonShape();
        box.setAsBox(0.5, 5.0);
        CircleShape circle2 = new CircleShape();
        circle2.m_radius = 2.0;
        BodyDef bd1 = new BodyDef();
        bd1.type = BodyType.STATIC;
        bd1.position.set(10.0, 9.0);
        Body body1 = this.m_world.createBody(bd1);
        body1.createFixture((Shape)circle1, 5.0);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(10.0, 8.0);
        Body body2 = this.m_world.createBody(bd2);
        body2.createFixture((Shape)box, 5.0);
        BodyDef bd3 = new BodyDef();
        bd3.type = BodyType.DYNAMIC;
        bd3.position.set(10.0, 6.0);
        Body body3 = this.m_world.createBody(bd3);
        body3.createFixture((Shape)circle2, 5.0);
        RevoluteJointDef jd1 = new RevoluteJointDef();
        jd1.initialize(body2, body1, bd1.position);
        Joint joint1 = this.m_world.createJoint((JointDef)jd1);
        RevoluteJointDef jd2 = new RevoluteJointDef();
        jd2.initialize(body2, body3, bd3.position);
        Joint joint2 = this.m_world.createJoint((JointDef)jd2);
        GearJointDef jd4 = new GearJointDef();
        jd4.bodyA = body1;
        jd4.bodyB = body3;
        jd4.joint1 = joint1;
        jd4.joint2 = joint2;
        jd4.ratio = circle2.m_radius / circle1.m_radius;
        this.m_world.createJoint((JointDef)jd4);
        circle1 = new CircleShape();
        circle1.m_radius = 1.0;
        CircleShape circle22 = new CircleShape();
        circle22.m_radius = 2.0;
        PolygonShape box2 = new PolygonShape();
        box2.setAsBox(0.5, 5.0);
        bd1 = new BodyDef();
        bd1.type = BodyType.DYNAMIC;
        bd1.position.set(-3.0, 12.0);
        body1 = this.m_world.createBody(bd1);
        body1.createFixture((Shape)circle1, 5.0);
        RevoluteJointDef jd12 = new RevoluteJointDef();
        jd12.bodyA = ground;
        jd12.bodyB = body1;
        ground.getLocalPointToOut(bd1.position, jd12.localAnchorA);
        body1.getLocalPointToOut(bd1.position, jd12.localAnchorB);
        jd12.referenceAngle = body1.getAngle() - ground.getAngle();
        this.m_joint1 = (RevoluteJoint)this.m_world.createJoint((JointDef)jd12);
        BodyDef bd22 = new BodyDef();
        bd22.type = BodyType.DYNAMIC;
        bd22.position.set(0.0, 12.0);
        Body body22 = this.m_world.createBody(bd22);
        body22.createFixture((Shape)circle22, 5.0);
        RevoluteJointDef jd22 = new RevoluteJointDef();
        jd22.initialize(ground, body22, bd22.position);
        this.m_joint2 = (RevoluteJoint)this.m_world.createJoint((JointDef)jd22);
        BodyDef bd32 = new BodyDef();
        bd32.type = BodyType.DYNAMIC;
        bd32.position.set(2.5, 12.0);
        Body body32 = this.m_world.createBody(bd32);
        body32.createFixture((Shape)box2, 5.0);
        PrismaticJointDef jd3 = new PrismaticJointDef();
        jd3.initialize(ground, body32, bd32.position, new Vec2(0.0, 1.0));
        jd3.lowerTranslation = -5.0;
        jd3.upperTranslation = 5.0;
        jd3.enableLimit = true;
        this.m_joint3 = (PrismaticJoint)this.m_world.createJoint((JointDef)jd3);
        GearJointDef jd42 = new GearJointDef();
        jd42.bodyA = body1;
        jd42.bodyB = body22;
        jd42.joint1 = this.m_joint1;
        jd42.joint2 = this.m_joint2;
        jd42.ratio = circle22.m_radius / circle1.m_radius;
        this.m_joint4 = (GearJoint)this.m_world.createJoint((JointDef)jd42);
        GearJointDef jd5 = new GearJointDef();
        jd5.bodyA = body22;
        jd5.bodyB = body32;
        jd5.joint1 = this.m_joint2;
        jd5.joint2 = this.m_joint3;
        jd5.ratio = 1.0 / circle22.m_radius;
        this.m_joint5 = (GearJoint)this.m_world.createJoint((JointDef)jd5);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        double ratio = this.m_joint4.getRatio();
        double value = this.m_joint1.getJointAngle() + ratio * this.m_joint2.getJointAngle();
        this.addTextLine("theta1 + " + ratio + " * theta2 = " + value);
        ratio = this.m_joint5.getRatio();
        value = this.m_joint2.getJointAngle() + ratio * this.m_joint3.getJointTranslation();
        this.addTextLine("theta2 + " + ratio + " * delta = " + value);
    }

    @Override
    public String getTestName() {
        return "Gears";
    }
}

