/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class FixedPendulumTest
extends TestbedTest {
    private final boolean switchBodiesInJoint;

    public FixedPendulumTest(boolean switchBodiesInJoint) {
        this.switchBodiesInJoint = switchBodiesInJoint;
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        CircleShape circleShape = new CircleShape();
        circleShape.m_radius = 1.0;
        CircleShape shape = circleShape;
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(-5.0, 0.0);
        bodyDef.allowSleep = false;
        Body pendulum = this.getWorld().createBody(bodyDef);
        pendulum.createFixture((Shape)shape, 1.0);
        BodyDef bodyDef2 = new BodyDef();
        bodyDef2.type = BodyType.STATIC;
        Body ground = this.getWorld().createBody(bodyDef2);
        RevoluteJointDef jointDef = new RevoluteJointDef();
        if (this.switchBodiesInJoint) {
            jointDef.initialize(pendulum, ground, new Vec2(0.0, 0.0));
        } else {
            jointDef.initialize(ground, pendulum, new Vec2(0.0, 0.0));
        }
        pendulum.applyAngularImpulse(10000.0);
        this.getWorld().createJoint((JointDef)jointDef);
    }

    @Override
    public String getTestName() {
        return "Fixed Pendulum " + (this.switchBodiesInJoint ? "1" : "0");
    }
}

