/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.tests.EdgeShapesCallback;

public class EdgeShapes
extends TestbedTest {
    int e_maxBodies = 256;
    int m_bodyIndex;
    Body[] m_bodies = new Body[this.e_maxBodies];
    PolygonShape[] m_polygons = new PolygonShape[4];
    CircleShape m_circle;
    double m_angle;
    EdgeShapesCallback callback = new EdgeShapesCallback();

    @Override
    public void initTest(boolean argDeserialized) {
        for (int i = 0; i < this.m_bodies.length; ++i) {
            this.m_bodies[i] = null;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        double x1 = -20.0;
        double y1 = 2.0 * MathUtils.cos((double)(x1 / 10.0 * Math.PI));
        for (int i = 0; i < 80; ++i) {
            double x2 = x1 + 0.5;
            double y2 = 2.0 * MathUtils.cos((double)(x2 / 10.0 * Math.PI));
            EdgeShape shape = new EdgeShape();
            shape.set(new Vec2(x1, y1), new Vec2(x2, y2));
            ground.createFixture((Shape)shape, 0.0);
            x1 = x2;
            y1 = y2;
        }
        Vec2[] vertices = new Vec2[]{new Vec2(-0.5, 0.0), new Vec2(0.5, 0.0), new Vec2(0.0, 1.5)};
        this.m_polygons[0] = new PolygonShape();
        this.m_polygons[0].set(vertices, 3);
        vertices = new Vec2[]{new Vec2((double)-0.1f, 0.0), new Vec2((double)0.1f, 0.0), new Vec2(0.0, 1.5)};
        this.m_polygons[1] = new PolygonShape();
        this.m_polygons[1].set(vertices, 3);
        double w = 1.0;
        double b = w / (2.0 + MathUtils.sqrt((double)2.0));
        double s = MathUtils.sqrt((double)2.0) * b;
        Vec2[] vertices2 = new Vec2[]{new Vec2(0.5 * s, 0.0), new Vec2(0.5 * w, b), new Vec2(0.5 * w, b + s), new Vec2(0.5 * s, w), new Vec2(-0.5 * s, w), new Vec2(-0.5 * w, b + s), new Vec2(-0.5 * w, b), new Vec2(-0.5 * s, 0.0)};
        this.m_polygons[2] = new PolygonShape();
        this.m_polygons[2].set(vertices2, 8);
        this.m_polygons[3] = new PolygonShape();
        this.m_polygons[3].setAsBox(0.5, 0.5);
        this.m_circle = new CircleShape();
        this.m_circle.m_radius = 0.5;
        this.m_bodyIndex = 0;
        this.m_angle = 0.0;
    }

    void Create(int index) {
        if (this.m_bodies[this.m_bodyIndex] != null) {
            this.getWorld().destroyBody(this.m_bodies[this.m_bodyIndex]);
            this.m_bodies[this.m_bodyIndex] = null;
        }
        BodyDef bd = new BodyDef();
        double x = MathUtils.randomDouble((double)-10.0, (double)10.0);
        double y = MathUtils.randomDouble((double)10.0, (double)20.0);
        bd.position.set(x, y);
        bd.angle = MathUtils.randomDouble((double)(-Math.PI), (double)Math.PI);
        bd.type = BodyType.DYNAMIC;
        if (index == 4) {
            bd.angularDamping = 0.02f;
        }
        this.m_bodies[this.m_bodyIndex] = this.getWorld().createBody(bd);
        if (index < 4) {
            FixtureDef fd = new FixtureDef();
            fd.shape = this.m_polygons[index];
            fd.friction = 0.3f;
            fd.density = 20.0;
            this.m_bodies[this.m_bodyIndex].createFixture(fd);
        } else {
            FixtureDef fd = new FixtureDef();
            fd.shape = this.m_circle;
            fd.friction = 0.3f;
            fd.density = 20.0;
            this.m_bodies[this.m_bodyIndex].createFixture(fd);
        }
        this.m_bodyIndex = (this.m_bodyIndex + 1) % this.e_maxBodies;
    }

    void DestroyBody() {
        for (int i = 0; i < this.e_maxBodies; ++i) {
            if (this.m_bodies[i] == null) continue;
            this.getWorld().destroyBody(this.m_bodies[i]);
            this.m_bodies[i] = null;
            return;
        }
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                this.Create(argKeyChar - 49);
                break;
            }
            case 'd': {
                this.DestroyBody();
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        boolean advanceRay = !settings.pause || settings.singleStep;
        super.step(settings);
        this.addTextLine("Press 1-5 to drop stuff");
        double L = 25.0;
        Vec2 point1 = new Vec2(0.0, 10.0);
        Vec2 d = new Vec2(L * MathUtils.cos((double)this.m_angle), -L * MathUtils.abs((double)MathUtils.sin((double)this.m_angle)));
        Vec2 point2 = point1.add(d);
        this.callback.m_fixture = null;
        this.getWorld().raycast((RayCastCallback)this.callback, point1, point2);
        if (this.callback.m_fixture != null) {
            this.getDebugDraw().drawPoint(this.callback.m_point, 5.0, new Color3f((double)0.4f, (double)0.9f, (double)0.4f));
            this.getDebugDraw().drawSegment(point1, this.callback.m_point, new Color3f((double)0.8f, (double)0.8f, (double)0.8f));
            Vec2 head = this.callback.m_normal.mul(0.5).addLocal(this.callback.m_point);
            this.getDebugDraw().drawSegment(this.callback.m_point, head, new Color3f((double)0.9f, (double)0.9f, (double)0.4f));
        } else {
            this.getDebugDraw().drawSegment(point1, point2, new Color3f((double)0.8f, (double)0.8f, (double)0.8f));
        }
        if (advanceRay) {
            this.m_angle += 0.004363323129985824;
        }
    }

    @Override
    public String getTestName() {
        return "Edge Shapes";
    }
}

