/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.particle.ParticleGroup;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class DrawingParticles
extends TestbedTest {
    ParticleGroup m_lastGroup;
    boolean m_drawing;
    int m_particleFlags;
    int m_groupFlags;
    ParticleColor color = new ParticleColor();
    Transform pxf = new Transform();
    CircleShape pshape = new CircleShape();
    ParticleGroupDef ppd = new ParticleGroupDef();

    @Override
    public void initTest(boolean deserialized) {
        PolygonShape shape = new PolygonShape();
        Vec2[] vertices = new Vec2[]{new Vec2(-40.0, -20.0), new Vec2(40.0, -20.0), new Vec2(40.0, 0.0), new Vec2(-40.0, 0.0)};
        shape.set(vertices, 4);
        this.getGroundBody().createFixture((Shape)shape, 0.0);
        shape = new PolygonShape();
        vertices = new Vec2[]{new Vec2(-40.0, -20.0), new Vec2(-20.0, -20.0), new Vec2(-20.0, 60.0), new Vec2(-40.0, 60.0)};
        shape.set(vertices, 4);
        this.getGroundBody().createFixture((Shape)shape, 0.0);
        shape = new PolygonShape();
        vertices = new Vec2[]{new Vec2(20.0, -20.0), new Vec2(40.0, -20.0), new Vec2(40.0, 60.0), new Vec2(20.0, 60.0)};
        shape.set(vertices, 4);
        this.getGroundBody().createFixture((Shape)shape, 0.0);
        shape = new PolygonShape();
        vertices = new Vec2[]{new Vec2(-40.0, 40.0), new Vec2(40.0, 40.0), new Vec2(40.0, 60.0), new Vec2(-40.0, 60.0)};
        shape.set(vertices, 4);
        this.getGroundBody().createFixture((Shape)shape, 0.0);
        this.m_world.setParticleRadius(0.5);
        this.m_lastGroup = null;
        this.m_drawing = true;
        this.m_groupFlags = 0;
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (L) liquid, (E) elastic, (S) spring");
        this.addTextLine("(F) rigid, (W) wall, (V) viscous, (T) tensile");
        this.addTextLine("(O) powder (Z) erase, (X) move");
    }

    @Override
    public void keyPressed(char keyChar, int keyCode) {
        this.m_drawing = keyChar != 'x';
        this.m_particleFlags = 0;
        this.m_groupFlags = 0;
        this.color.set((byte)127, (byte)127, (byte)127, (byte)50);
        switch (keyChar) {
            case 'e': {
                this.m_particleFlags = 16;
                this.m_groupFlags = 1;
                break;
            }
            case 'o': {
                this.m_particleFlags = 64;
                break;
            }
            case 'f': {
                this.m_groupFlags = 3;
                break;
            }
            case 's': {
                this.m_particleFlags = 8;
                this.m_groupFlags = 1;
                break;
            }
            case 't': {
                this.color.set((byte)0, (byte)127, (byte)0, (byte)50);
                this.m_particleFlags = 128;
                break;
            }
            case 'v': {
                this.color.set((byte)0, (byte)0, (byte)127, (byte)50);
                this.m_particleFlags = 32;
                break;
            }
            case 'w': {
                this.m_particleFlags = 4;
                this.m_groupFlags = 1;
                break;
            }
            case 'z': {
                this.m_particleFlags = 2;
            }
        }
    }

    @Override
    public void mouseDrag(Vec2 p, int button) {
        super.mouseDrag(p, button);
        if (this.m_drawing) {
            this.pshape.m_p.set(p);
            this.pshape.m_radius = 2.0;
            this.pxf.setIdentity();
            this.m_world.destroyParticlesInShape((Shape)this.pshape, this.pxf);
            this.ppd.shape = this.pshape;
            this.ppd.color = this.color;
            this.ppd.flags = this.m_particleFlags;
            this.ppd.groupFlags = this.m_groupFlags;
            ParticleGroup group = this.m_world.createParticleGroup(this.ppd);
            if (this.m_lastGroup != null && group.getGroupFlags() == this.m_lastGroup.getGroupFlags()) {
                this.m_world.joinParticleGroups(this.m_lastGroup, group);
            } else {
                this.m_lastGroup = group;
            }
            this.mouseTracing = false;
        }
    }

    @Override
    public void mouseUp(Vec2 p, int button) {
        super.mouseUp(p, button);
        this.m_lastGroup = null;
    }

    @Override
    public void particleGroupDestroyed(ParticleGroup group) {
        super.particleGroupDestroyed(group);
        if (group == this.m_lastGroup) {
            this.m_lastGroup = null;
        }
    }

    @Override
    public String getTestName() {
        return "Drawing Particles";
    }
}

