/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.testbed.framework.TestbedTest;

public class DominoTower
extends TestbedTest {
    final double dwidth = 0.2f;
    final double dheight = 1.0;
    double ddensity;
    final double dfriction = 0.1f;
    int baseCount = 25;

    public void makeDomino(double x, double y, boolean horizontal, World world) {
        PolygonShape sd = new PolygonShape();
        sd.setAsBox((double)0.1f, 0.5);
        FixtureDef fd = new FixtureDef();
        fd.shape = sd;
        fd.density = this.ddensity;
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        fd.friction = 0.1f;
        fd.restitution = 0.65f;
        bd.position = new Vec2(x, y);
        bd.angle = horizontal ? 1.5707963267948966 : 0.0;
        Body myBody = this.getWorld().createBody(bd);
        myBody.createFixture(fd);
    }

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0, 12.0);
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(50.0, 10.0);
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(0.0, -10.0);
        this.getWorld().createBody(bd).createFixture((Shape)sd, 0.0);
        this.ddensity = 10.0;
        sd = new PolygonShape();
        sd.setAsBox((double)0.7f, (double)0.7f);
        FixtureDef fd = new FixtureDef();
        fd.density = 35.0;
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        fd.shape = sd;
        fd.friction = 0.0;
        fd.restitution = 0.85f;
        bd2.bullet = true;
        bd2.position = new Vec2(30.0, 50.0);
        Body b = this.getWorld().createBody(bd2);
        b.createFixture(fd);
        b.setLinearVelocity(new Vec2(-25.0, -25.0));
        b.setAngularVelocity((double)6.7f);
        fd.density = 25.0;
        bd2.position = new Vec2(-30.0, 25.0);
        b = this.getWorld().createBody(bd2);
        b.createFixture(fd);
        b.setLinearVelocity(new Vec2(35.0, -10.0));
        b.setAngularVelocity((double)-8.3f);
        for (int i = 0; i < this.baseCount; ++i) {
            double currX = (double)((float)i * 1.5f) * 1.0 - 1.5 * (double)this.baseCount / 2.0;
            this.makeDomino(currX, 0.5, false, this.m_world);
            this.makeDomino(currX, 1.1000000014901161, true, this.m_world);
        }
        double currX = (double)((float)this.baseCount * 1.5f) * 1.0 - 1.5 * (double)this.baseCount / 2.0;
        for (int j = 1; j < this.baseCount; ++j) {
            if (j > 3) {
                this.ddensity *= (double)0.8f;
            }
            double currY = 0.5 + 1.3860000192523003 * (double)j;
            for (int i = 0; i < this.baseCount - j; ++i) {
                currX = (double)((float)i * 1.5f) * 1.0 - 1.5 * (double)(this.baseCount - j) / 2.0;
                this.ddensity *= 2.5;
                if (i == 0) {
                    this.makeDomino(currX - 1.25 + (double)0.1f, currY - (double)0.2f, false, this.m_world);
                }
                if (i == this.baseCount - j - 1) {
                    this.makeDomino(currX + 1.25 - (double)0.1f, currY - (double)0.2f, false, this.m_world);
                }
                this.ddensity /= 2.5;
                this.makeDomino(currX, currY, false, this.m_world);
                this.makeDomino(currX, currY + 0.6000000014901161, true, this.m_world);
                this.makeDomino(currX, currY - 0.6000000014901161, true, this.m_world);
            }
        }
    }

    @Override
    public String getTestName() {
        return "Domino Tower";
    }
}

