/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class DominoTest
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        FixtureDef fd = new FixtureDef();
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(50.0, 10.0);
        fd.shape = sd;
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(0.0, -10.0);
        this.getWorld().createBody(bd).createFixture(fd);
        for (int i = 0; i < 4; ++i) {
            FixtureDef fd2 = new FixtureDef();
            PolygonShape sd2 = new PolygonShape();
            sd2.setAsBox(15.0, 0.125);
            fd2.shape = sd2;
            BodyDef bd2 = new BodyDef();
            bd2.position = new Vec2(0.0, (double)(5.0f + 5.0f * (float)i));
            this.getWorld().createBody(bd2).createFixture(fd2);
        }
        fd = new FixtureDef();
        sd = new PolygonShape();
        sd.setAsBox(0.125, 2.0);
        fd.shape = sd;
        fd.density = 25.0;
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        double friction = 0.5;
        int numPerRow = 25;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < numPerRow; ++j) {
                fd.friction = friction;
                bd.position = new Vec2((double)(-14.75f + (float)j * (29.5f / (float)(numPerRow - 1))), (double)(7.3f + 5.0f * (float)i));
                if (i == 2 && j == 0) {
                    bd.angle = -0.1f;
                    bd.position.x += (double)0.1f;
                } else if (i == 3 && j == numPerRow - 1) {
                    bd.angle = 0.1f;
                    bd.position.x -= (double)0.1f;
                } else {
                    bd.angle = 0.0;
                }
                Body myBody = this.getWorld().createBody(bd);
                myBody.createFixture(fd);
            }
        }
    }

    @Override
    public String getTestName() {
        return "Dominos";
    }
}

