/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class DistanceTest
extends TestbedTest {
    Vec2 m_positionB;
    double m_angleB;
    Transform m_transformA;
    Transform m_transformB;
    PolygonShape m_polygonA;
    PolygonShape m_polygonB;
    DistanceInput input = new DistanceInput();
    Distance.SimplexCache cache = new Distance.SimplexCache();
    DistanceOutput output = new DistanceOutput();
    Color3f color = new Color3f((double)0.9f, (double)0.9f, (double)0.9f);
    Vec2[] v = new Vec2[Settings.maxPolygonVertices];
    Color3f c1 = new Color3f(1.0, 0.0, 0.0);
    Color3f c2 = new Color3f(1.0, 1.0, 0.0);

    @Override
    public String getTestName() {
        return "Distance";
    }

    @Override
    public void initTest(boolean argDeserialized) {
        this.input.transformA = new Transform();
        this.input.transformB = new Transform();
        this.m_transformA = new Transform();
        this.m_transformA.setIdentity();
        this.m_transformA.p.set(0.0, (double)-0.2f);
        this.m_polygonA = new PolygonShape();
        this.m_polygonA.setAsBox(10.0, (double)0.2f);
        this.m_positionB = new Vec2();
        this.m_positionB.set(12.017400741577148, 0.13678507506847382);
        this.m_angleB = -0.0109265f;
        this.m_transformB = new Transform();
        this.m_transformB.set(this.m_positionB, this.m_angleB);
        this.m_polygonB = new PolygonShape();
        this.m_polygonB.setAsBox(2.0, (double)0.1f);
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = new Vec2();
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        int i;
        super.step(settings);
        this.input.proxyA.set((Shape)this.m_polygonA, 0);
        this.input.proxyB.set((Shape)this.m_polygonB, 0);
        this.input.transformA.set(this.m_transformA);
        this.input.transformB.set(this.m_transformB);
        this.input.useRadii = true;
        this.cache.count = 0;
        this.getWorld().getPool().getDistance().distance(this.output, this.cache, this.input);
        this.addTextLine("distance = " + this.output.distance);
        this.addTextLine("iterations = " + this.output.iterations);
        for (i = 0; i < this.m_polygonA.m_count; ++i) {
            Transform.mulToOutUnsafe((Transform)this.m_transformA, (Vec2)this.m_polygonA.m_vertices[i], (Vec2)this.v[i]);
        }
        this.getDebugDraw().drawPolygon(this.v, this.m_polygonA.m_count, this.color);
        for (i = 0; i < this.m_polygonB.m_count; ++i) {
            Transform.mulToOutUnsafe((Transform)this.m_transformB, (Vec2)this.m_polygonB.m_vertices[i], (Vec2)this.v[i]);
        }
        this.getDebugDraw().drawPolygon(this.v, this.m_polygonB.m_count, this.color);
        Vec2 x1 = this.output.pointA;
        Vec2 x2 = this.output.pointB;
        this.getDebugDraw().drawPoint(x1, 4.0, this.c1);
        this.getDebugDraw().drawPoint(x2, 4.0, this.c2);
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'a': {
                this.m_positionB.x -= (double)0.1f;
                break;
            }
            case 'd': {
                this.m_positionB.x += (double)0.1f;
                break;
            }
            case 's': {
                this.m_positionB.y -= (double)0.1f;
                break;
            }
            case 'w': {
                this.m_positionB.y += (double)0.1f;
                break;
            }
            case 'q': {
                this.m_angleB += 0.3141592700403172;
                break;
            }
            case 'e': {
                this.m_angleB -= 0.3141592700403172;
            }
        }
        this.m_transformB.set(this.m_positionB, this.m_angleB);
    }
}

