/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedTest;

public class ConveyorBelt
extends TestbedTest {
    private static long platformTag = 98752L;
    private Fixture m_platform;

    @Override
    public Long getTag(Fixture argFixture) {
        if (argFixture == this.m_platform) {
            return platformTag;
        }
        return super.getTag(argFixture);
    }

    @Override
    public void processFixture(Fixture argFixture, Long argTag) {
        if (argTag == platformTag) {
            this.m_platform = argFixture;
            return;
        }
        super.processFixture(argFixture, argTag);
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-20.0, 0.0), new Vec2(20.0, 0.0));
        this.getGroundBody().createFixture((Shape)shape, 0.0);
        BodyDef bd = new BodyDef();
        bd.position.set(-5.0, 5.0);
        Body body = this.getWorld().createBody(bd);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(10.0, 0.5);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.friction = 0.8f;
        this.m_platform = body.createFixture(fd);
        for (int i = 0; i < 5; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set((double)(-10.0f + 2.0f * (float)i), 7.0);
            Body body2 = this.m_world.createBody(bd2);
            PolygonShape shape3 = new PolygonShape();
            shape3.setAsBox(0.5, 0.5);
            body2.createFixture((Shape)shape3, 20.0);
        }
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        super.preSolve(contact, oldManifold);
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (fixtureA == this.m_platform || fixtureB == this.m_platform) {
            contact.setTangentSpeed(5.0);
        }
    }

    @Override
    public String getTestName() {
        return "Conveyor Belt";
    }
}

