/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ConvexHull
extends TestbedTest {
    private final int e_count = Settings.maxPolygonVertices;
    private boolean m_auto = false;
    private Vec2[] m_points = new Vec2[Settings.maxPolygonVertices];
    private int m_count;
    PolygonShape shape = new PolygonShape();
    Color3f color = new Color3f((double)0.9f, (double)0.9f, (double)0.9f);
    Color3f color2 = new Color3f((double)0.9f, 0.5, 0.5);

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        this.generate();
    }

    void generate() {
        Vec2 lowerBound = new Vec2(-8.0, -8.0);
        Vec2 upperBound = new Vec2(8.0, 8.0);
        for (int i = 0; i < this.e_count; ++i) {
            double x = MathUtils.randomDouble((double)-8.0, (double)8.0);
            double y = MathUtils.randomDouble((double)-8.0, (double)8.0);
            Vec2 v = new Vec2(x, y);
            MathUtils.clampToOut((Vec2)v, (Vec2)lowerBound, (Vec2)upperBound, (Vec2)v);
            this.m_points[i] = v;
        }
        this.m_count = this.e_count;
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        if (argKeyChar == 'g') {
            this.generate();
        } else if (argKeyChar == 'a') {
            this.m_auto = !this.m_auto;
        }
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        this.shape.set(this.m_points, this.m_count);
        this.addTextLine("Press g to generate a new random convex hull");
        this.getDebugDraw().drawPolygon(this.shape.m_vertices, this.shape.m_count, this.color);
        for (int i = 0; i < this.m_count; ++i) {
            this.getDebugDraw().drawPoint(this.m_points[i], 2.0, this.color2);
            this.getDebugDraw().drawString(this.m_points[i].add(new Vec2((double)0.05f, (double)0.05f)), "" + i, Color3f.WHITE);
        }
        assert (this.shape.validate());
        if (this.m_auto) {
            this.generate();
        }
    }

    @Override
    public String getTestName() {
        return "Convex Hull";
    }
}

