/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ContinuousTest
extends TestbedTest {
    Body m_body;
    Fixture currFixture;
    PolygonShape m_poly;
    CircleShape m_circle;
    Shape nextShape = null;
    boolean polygon = false;
    double m_angularVelocity;

    @Override
    public String getTestName() {
        return "Continuous";
    }

    public void switchObjects() {
        this.nextShape = this.polygon ? this.m_circle : this.m_poly;
        this.polygon = !this.polygon;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        bd.position.set(0.0, 0.0);
        Body body = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-10.0, 0.0), new Vec2(10.0, 0.0));
        body.createFixture((Shape)shape, 0.0);
        PolygonShape pshape = new PolygonShape();
        pshape.setAsBox((double)0.2f, 1.0, new Vec2(0.5, 1.0), 0.0);
        body.createFixture((Shape)pshape, 0.0);
        this.m_poly = new PolygonShape();
        this.m_poly.setAsBox(2.0, (double)0.1f);
        this.m_circle = new CircleShape();
        this.m_circle.m_p.setZero();
        this.m_circle.m_radius = 0.5;
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 20.0);
        this.m_body = this.getWorld().createBody(bd);
        this.currFixture = this.m_body.createFixture((Shape)this.m_poly, 1.0);
        this.m_angularVelocity = Math.random() * 100.0 - 50.0;
        this.m_angularVelocity = 33.46812057495117;
        this.m_body.setLinearVelocity(new Vec2(0.0, -100.0));
        this.m_body.setAngularVelocity(this.m_angularVelocity);
        TimeOfImpact.toiCalls = 0;
        TimeOfImpact.toiIters = 0;
        TimeOfImpact.toiMaxIters = 0;
        TimeOfImpact.toiRootIters = 0;
        TimeOfImpact.toiMaxRootIters = 0;
    }

    public void launch() {
        this.m_body.setTransform(new Vec2(0.0, 20.0), 0.0);
        this.m_angularVelocity = Math.random() * 100.0 - 50.0;
        this.m_body.setLinearVelocity(new Vec2(0.0, -100.0));
        this.m_body.setAngularVelocity(this.m_angularVelocity);
    }

    @Override
    public void step(TestbedSettings settings) {
        if (this.nextShape != null) {
            this.m_body.destroyFixture(this.currFixture);
            this.currFixture = this.m_body.createFixture(this.nextShape, 1.0);
            this.nextShape = null;
        }
        super.step(settings);
        if (Distance.GJK_CALLS > 0) {
            this.addTextLine(String.format("gjk calls = %d, ave gjk iters = %3.1f, max gjk iters = %d", Distance.GJK_CALLS, (double)Distance.GJK_ITERS * 1.0 / (double)Distance.GJK_CALLS, Distance.GJK_MAX_ITERS));
        }
        if (TimeOfImpact.toiCalls > 0) {
            int toiCalls = TimeOfImpact.toiCalls;
            int toiIters = TimeOfImpact.toiIters;
            int toiMaxIters = TimeOfImpact.toiMaxIters;
            int toiRootIters = TimeOfImpact.toiRootIters;
            int toiMaxRootIters = TimeOfImpact.toiMaxRootIters;
            this.addTextLine(String.format("toi calls = %d, ave toi iters = %3.1f, max toi iters = %d", toiCalls, (double)toiIters * 1.0 / (double)toiCalls, toiMaxIters));
            this.addTextLine(String.format("ave toi root iters = %3.1f, max toi root iters = %d", (double)toiRootIters * 1.0 / (double)toiCalls, toiMaxRootIters));
        }
        this.addTextLine("Press 'c' to change launch shape");
        if (this.getStepCount() % 60 == 0) {
            this.launch();
        }
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'c': {
                this.switchObjects();
            }
        }
    }
}

