/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ConfinedTest
extends TestbedTest {
    int e_columnCount = 0;
    int e_rowCount = 0;

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public String getTestName() {
        return "Confined";
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-10.0, 0.0), new Vec2(10.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        shape.set(new Vec2(-10.0, 0.0), new Vec2(-10.0, 20.0));
        ground.createFixture((Shape)shape, 0.0);
        shape.set(new Vec2(10.0, 0.0), new Vec2(10.0, 20.0));
        ground.createFixture((Shape)shape, 0.0);
        shape.set(new Vec2(-10.0, 20.0), new Vec2(10.0, 20.0));
        ground.createFixture((Shape)shape, 0.0);
        double radius = 0.5;
        shape = new CircleShape();
        shape.m_p.setZero();
        shape.m_radius = radius;
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 1.0;
        fd.friction = 0.1f;
        for (int j = 0; j < this.e_columnCount; ++j) {
            for (int i = 0; i < this.e_rowCount; ++i) {
                BodyDef bd2 = new BodyDef();
                bd2.type = BodyType.DYNAMIC;
                bd2.position.set(-10.0 + (double)(2.1f * (float)j + 1.0f + 0.01f * (float)i) * radius, (double)(2.0f * (float)i + 1.0f) * radius);
                Body body = this.getWorld().createBody(bd2);
                body.createFixture(fd);
            }
        }
        this.getWorld().setGravity(new Vec2(0.0, 0.0));
    }

    public void createCircle() {
        double radius = 2.0;
        CircleShape shape = new CircleShape();
        shape.m_p.setZero();
        shape.m_radius = radius;
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 1.0;
        fd.friction = 0.0;
        Vec2 p = new Vec2(Math.random(), 3.0 + Math.random());
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position = p;
        Body body = this.getWorld().createBody(bd);
        body.createFixture(fd);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        for (Body b = this.getWorld().getBodyList(); b != null; b = b.getNext()) {
            if (b.getType() != BodyType.DYNAMIC) continue;
            Vec2 p = b.getPosition();
            if (!(p.x <= -10.0 || 10.0 <= p.x || p.y <= 0.0) && !(20.0 <= p.y)) continue;
            p.x += 0.0;
        }
        this.addTextLine("Press 'c' to create a circle");
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'c': {
                this.createCircle();
            }
        }
    }
}

