/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.testbed.framework.TestbedTest;

public class CompoundShapes
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        Body body;
        BodyDef bd;
        double x;
        int i;
        if (deserialized) {
            return;
        }
        BodyDef bd2 = new BodyDef();
        bd2.position.set(0.0, 0.0);
        Body body2 = this.getWorld().createBody(bd2);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(50.0, 0.0), new Vec2(-50.0, 0.0));
        body2.createFixture((Shape)shape, 0.0);
        CircleShape circle1 = new CircleShape();
        circle1.m_radius = 0.5;
        circle1.m_p.set(-0.5, 0.5);
        CircleShape circle2 = new CircleShape();
        circle2.m_radius = 0.5;
        circle2.m_p.set(0.5, 0.5);
        for (i = 0; i < 10; ++i) {
            x = MathUtils.randomDouble((double)-0.1f, (double)0.1f);
            bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(x + 5.0, (double)(1.05f + 2.5f * (float)i));
            bd.angle = MathUtils.randomDouble((double)(-Math.PI), (double)Math.PI);
            body = this.getWorld().createBody(bd);
            body.createFixture((Shape)circle1, 2.0);
            body.createFixture((Shape)circle2, 0.0);
        }
        PolygonShape polygon1 = new PolygonShape();
        polygon1.setAsBox(0.25, 0.5);
        PolygonShape polygon2 = new PolygonShape();
        polygon2.setAsBox(0.25, 0.5, new Vec2(0.0, -0.5), 1.5707963267948966);
        for (i = 0; i < 10; ++i) {
            x = MathUtils.randomDouble((double)-0.1f, (double)0.1f);
            bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(x - 5.0, (double)(1.05f + 2.5f * (float)i));
            bd.angle = MathUtils.randomDouble((double)(-Math.PI), (double)Math.PI);
            body = this.getWorld().createBody(bd);
            body.createFixture((Shape)polygon1, 2.0);
            body.createFixture((Shape)polygon2, 2.0);
        }
        Transform xf1 = new Transform();
        xf1.q.set(1.10709726640493);
        Rot.mulToOut((Rot)xf1.q, (Vec2)new Vec2(1.0, 0.0), (Vec2)xf1.p);
        Vec2[] vertices = new Vec2[3];
        PolygonShape triangle1 = new PolygonShape();
        vertices[0] = Transform.mul((Transform)xf1, (Vec2)new Vec2(-1.0, 0.0));
        vertices[1] = Transform.mul((Transform)xf1, (Vec2)new Vec2(1.0, 0.0));
        vertices[2] = Transform.mul((Transform)xf1, (Vec2)new Vec2(0.0, 0.5));
        triangle1.set(vertices, 3);
        Transform xf2 = new Transform();
        xf2.q.set(-1.10709726640493);
        Rot.mulToOut((Rot)xf2.q, (Vec2)new Vec2(-1.0, 0.0), (Vec2)xf2.p);
        PolygonShape triangle2 = new PolygonShape();
        vertices[0] = Transform.mul((Transform)xf2, (Vec2)new Vec2(-1.0, 0.0));
        vertices[1] = Transform.mul((Transform)xf2, (Vec2)new Vec2(1.0, 0.0));
        vertices[2] = Transform.mul((Transform)xf2, (Vec2)new Vec2(0.0, 0.5));
        triangle2.set(vertices, 3);
        for (int i2 = 0; i2 < 10; ++i2) {
            double x2 = MathUtils.randomDouble((double)-0.1f, (double)0.1f);
            BodyDef bd3 = new BodyDef();
            bd3.type = BodyType.DYNAMIC;
            bd3.position.set(x2, (double)(2.05f + 2.5f * (float)i2));
            bd3.angle = 0.0;
            Body body3 = this.getWorld().createBody(bd3);
            body3.createFixture((Shape)triangle1, 2.0);
            body3.createFixture((Shape)triangle2, 2.0);
        }
        PolygonShape bottom = new PolygonShape();
        bottom.setAsBox(1.5, (double)0.15f);
        PolygonShape left = new PolygonShape();
        left.setAsBox((double)0.15f, (double)2.7f, new Vec2((double)-1.45f, (double)2.35f), (double)0.2f);
        PolygonShape right = new PolygonShape();
        right.setAsBox((double)0.15f, (double)2.7f, new Vec2((double)1.45f, (double)2.35f), (double)-0.2f);
        BodyDef bd4 = new BodyDef();
        bd4.type = BodyType.DYNAMIC;
        bd4.position.set(0.0, 2.0);
        Body body4 = this.getWorld().createBody(bd4);
        body4.createFixture((Shape)bottom, 4.0);
        body4.createFixture((Shape)left, 4.0);
        body4.createFixture((Shape)right, 4.0);
    }

    @Override
    public String getTestName() {
        return "Compound Shapes";
    }
}

