/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class CollisionFiltering
extends TestbedTest {
    final int k_smallGroup = 1;
    final int k_largeGroup = -1;
    final int k_defaultCategory = 1;
    final int k_triangleCategory = 2;
    final int k_boxCategory = 4;
    final int k_circleCategory = 8;
    final int k_triangleMask = 65535;
    final int k_boxMask = 65533;
    final int k_circleMask = 65535;

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        FixtureDef sd = new FixtureDef();
        sd.shape = shape;
        sd.friction = 0.3f;
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        ground.createFixture(sd);
        Vec2[] vertices = new Vec2[]{new Vec2(-1.0, 0.0), new Vec2(1.0, 0.0), new Vec2(0.0, 2.0)};
        PolygonShape polygon = new PolygonShape();
        polygon.set(vertices, 3);
        FixtureDef triangleShapeDef = new FixtureDef();
        triangleShapeDef.shape = polygon;
        triangleShapeDef.density = 1.0;
        triangleShapeDef.filter.groupIndex = 1;
        triangleShapeDef.filter.categoryBits = 2;
        triangleShapeDef.filter.maskBits = 65535;
        BodyDef triangleBodyDef = new BodyDef();
        triangleBodyDef.type = BodyType.DYNAMIC;
        triangleBodyDef.position.set(-5.0, 2.0);
        Body body1 = this.getWorld().createBody(triangleBodyDef);
        body1.createFixture(triangleShapeDef);
        vertices[0].mulLocal(2.0);
        vertices[1].mulLocal(2.0);
        vertices[2].mulLocal(2.0);
        polygon.set(vertices, 3);
        triangleShapeDef.filter.groupIndex = -1;
        triangleBodyDef.position.set(-5.0, 6.0);
        triangleBodyDef.fixedRotation = true;
        Body body2 = this.getWorld().createBody(triangleBodyDef);
        body2.createFixture(triangleShapeDef);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(-5.0, 10.0);
        Body body = this.getWorld().createBody(bd2);
        PolygonShape p = new PolygonShape();
        p.setAsBox(0.5, 1.0);
        body.createFixture((Shape)p, 1.0);
        PrismaticJointDef jd = new PrismaticJointDef();
        jd.bodyA = body2;
        jd.bodyB = body;
        jd.enableLimit = true;
        jd.localAnchorA.set(0.0, 4.0);
        jd.localAnchorB.setZero();
        jd.localAxisA.set(0.0, 1.0);
        jd.lowerTranslation = -1.0;
        jd.upperTranslation = 1.0;
        this.getWorld().createJoint((JointDef)jd);
        polygon.setAsBox(1.0, 0.5);
        FixtureDef boxShapeDef = new FixtureDef();
        boxShapeDef.shape = polygon;
        boxShapeDef.density = 1.0;
        boxShapeDef.restitution = 0.1f;
        boxShapeDef.filter.groupIndex = 1;
        boxShapeDef.filter.categoryBits = 4;
        boxShapeDef.filter.maskBits = 65533;
        BodyDef boxBodyDef = new BodyDef();
        boxBodyDef.type = BodyType.DYNAMIC;
        boxBodyDef.position.set(0.0, 2.0);
        Body body3 = this.getWorld().createBody(boxBodyDef);
        body3.createFixture(boxShapeDef);
        polygon.setAsBox(2.0, 1.0);
        boxShapeDef.filter.groupIndex = -1;
        boxBodyDef.position.set(0.0, 6.0);
        Body body4 = this.getWorld().createBody(boxBodyDef);
        body4.createFixture(boxShapeDef);
        CircleShape circle = new CircleShape();
        circle.m_radius = 1.0;
        FixtureDef circleShapeDef = new FixtureDef();
        circleShapeDef.shape = circle;
        circleShapeDef.density = 1.0;
        circleShapeDef.filter.groupIndex = 1;
        circleShapeDef.filter.categoryBits = 8;
        circleShapeDef.filter.maskBits = 65535;
        BodyDef circleBodyDef = new BodyDef();
        circleBodyDef.type = BodyType.DYNAMIC;
        circleBodyDef.position.set(5.0, 2.0);
        Body body5 = this.getWorld().createBody(circleBodyDef);
        body5.createFixture(circleShapeDef);
        circle.m_radius *= 2.0;
        circleShapeDef.filter.groupIndex = -1;
        circleBodyDef.position.set(5.0, 6.0);
        Body body6 = this.getWorld().createBody(circleBodyDef);
        body6.createFixture(circleShapeDef);
    }

    @Override
    public String getTestName() {
        return "Collision Filtering";
    }
}

