/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CircleStress
extends TestbedTest {
    private static final long JOINT_TAG = 1L;
    private RevoluteJoint joint;

    @Override
    public Long getTag(Joint argJoint) {
        if (argJoint == this.joint) {
            return 1L;
        }
        return null;
    }

    @Override
    public void processJoint(Joint argJoint, Long argTag) {
        if (argTag == 1L) {
            this.joint = (RevoluteJoint)argJoint;
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0, 20.0);
    }

    @Override
    public double getDefaultCameraScale() {
        return 5.0;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        Body leftWall = null;
        Body rightWall = null;
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(50.0, 10.0);
        BodyDef bd = new BodyDef();
        bd.type = BodyType.STATIC;
        bd.position = new Vec2(0.0, -10.0);
        Body b = this.getWorld().createBody(bd);
        FixtureDef fd = new FixtureDef();
        fd.shape = sd;
        fd.friction = 1.0;
        b.createFixture(fd);
        sd.setAsBox(3.0, 50.0);
        bd = new BodyDef();
        bd.position = new Vec2(45.0, 25.0);
        rightWall = this.getWorld().createBody(bd);
        rightWall.createFixture((Shape)sd, 0.0);
        bd.position = new Vec2(-45.0, 25.0);
        leftWall = this.getWorld().createBody(bd);
        leftWall.createFixture((Shape)sd, 0.0);
        bd = new BodyDef();
        sd.setAsBox(20.0, 3.0);
        bd.angle = -0.7853981633974483;
        bd.position = new Vec2(-35.0, 8.0);
        Body myBod = this.getWorld().createBody(bd);
        myBod.createFixture((Shape)sd, 0.0);
        bd.angle = 0.7853981633974483;
        bd.position = new Vec2(35.0, 8.0);
        myBod = this.getWorld().createBody(bd);
        myBod.createFixture((Shape)sd, 0.0);
        sd.setAsBox(50.0, 10.0);
        bd.type = BodyType.STATIC;
        bd.angle = 0.0;
        bd.position = new Vec2(0.0, 75.0);
        b = this.getWorld().createBody(bd);
        fd.shape = sd;
        fd.friction = 1.0;
        b.createFixture(fd);
        FixtureDef fd2 = new FixtureDef();
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        int numPieces = 5;
        double radius = 6.0;
        bd2.position = new Vec2(0.0, 10.0);
        Body body = this.getWorld().createBody(bd2);
        for (int i = 0; i < numPieces; ++i) {
            CircleShape cd = new CircleShape();
            cd.m_radius = 1.2f;
            fd2.shape = cd;
            fd2.density = 25.0;
            fd2.friction = 0.1f;
            fd2.restitution = 0.9f;
            double xPos = radius * Math.cos(Math.PI * 2 * ((double)i / (double)numPieces));
            double yPos = radius * Math.sin(Math.PI * 2 * ((double)i / (double)numPieces));
            cd.m_p.set(xPos, yPos);
            body.createFixture(fd2);
        }
        body.setBullet(false);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(body, this.getGroundBody(), body.getPosition());
        rjd.motorSpeed = Math.PI;
        rjd.maxMotorTorque = 1000000.0;
        rjd.enableMotor = true;
        this.joint = (RevoluteJoint)this.getWorld().createJoint((JointDef)rjd);
        int loadSize = 41;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < loadSize; ++i) {
                CircleShape circ = new CircleShape();
                BodyDef bod = new BodyDef();
                bod.type = BodyType.DYNAMIC;
                circ.m_radius = 1.0 + (double)((i % 2 == 0 ? 1.0f : -1.0f) * 0.5f) * MathUtils.randomDouble((double)0.5, (double)1.0);
                FixtureDef fd22 = new FixtureDef();
                fd22.shape = circ;
                fd22.density = circ.m_radius * 1.5;
                fd22.friction = 0.5;
                fd22.restitution = 0.7f;
                double xPos = -39.0f + (float)(2 * i);
                double yPos = 50.0f + (float)j;
                bod.position = new Vec2(xPos, yPos);
                Body myBody = this.getWorld().createBody(bod);
                myBody.createFixture(fd22);
            }
        }
        this.getWorld().setGravity(new Vec2(0.0, -50.0));
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 's': {
                this.joint.setMotorSpeed(0.0);
                break;
            }
            case '1': {
                this.joint.setMotorSpeed(Math.PI);
                break;
            }
            case '2': {
                this.joint.setMotorSpeed(Math.PI * 2);
                break;
            }
            case '3': {
                this.joint.setMotorSpeed(Math.PI * 3);
                break;
            }
            case '4': {
                this.joint.setMotorSpeed(Math.PI * 6);
                break;
            }
            case '5': {
                this.joint.setMotorSpeed(Math.PI * 10);
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press 's' to stop, and '1' - '5' to change speeds");
    }

    @Override
    public String getTestName() {
        return "Circle Stress Test";
    }
}

