/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CharacterCollision
extends TestbedTest {
    private static final long CHARACTER_TAG = 1231L;
    private Body m_character;

    @Override
    public Long getTag(Body argBody) {
        if (argBody == this.m_character) {
            return 1231L;
        }
        return super.getTag(argBody);
    }

    @Override
    public void processBody(Body argBody, Long argTag) {
        if (argTag == 1231L) {
            this.m_character = argBody;
            return;
        }
        super.processBody(argBody, argTag);
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-20.0, 0.0), new Vec2(20.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        shape = new EdgeShape();
        shape.m_radius = 0.0;
        shape.set(new Vec2(-8.0, 1.0), new Vec2(-6.0, 1.0));
        ground.createFixture((Shape)shape, 0.0);
        shape.set(new Vec2(-6.0, 1.0), new Vec2(-4.0, 1.0));
        ground.createFixture((Shape)shape, 0.0);
        shape.set(new Vec2(-4.0, 1.0), new Vec2(-2.0, 1.0));
        ground.createFixture((Shape)shape, 0.0);
        bd = new BodyDef();
        bd.angle = 0.7853981633974483;
        ground = this.getWorld().createBody(bd);
        Vec2[] vs = new Vec2[]{new Vec2(5.0, 7.0), new Vec2(6.0, 8.0), new Vec2(7.0, 8.0), new Vec2(8.0, 7.0)};
        ChainShape shape2 = new ChainShape();
        shape2.createChain(vs, 4);
        ground.createFixture((Shape)shape2, 0.0);
        bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(1.0, 1.0, new Vec2(4.0, 3.0), 0.0);
        ground.createFixture((Shape)shape, 0.0);
        shape.setAsBox(1.0, 1.0, new Vec2(6.0, 3.0), 0.0);
        ground.createFixture((Shape)shape, 0.0);
        shape.setAsBox(1.0, 1.0, new Vec2(8.0, 3.0), 0.0);
        ground.createFixture((Shape)shape, 0.0);
        bd = new BodyDef();
        ground = this.m_world.createBody(bd);
        vs = new Vec2[]{new Vec2(-1.0, 3.0), new Vec2(1.0, 3.0), new Vec2(1.0, 5.0), new Vec2(-1.0, 5.0)};
        shape2 = new ChainShape();
        shape2.createLoop(vs, 4);
        ground.createFixture((Shape)shape2, 0.0);
        bd = new BodyDef();
        bd.position.set(-10.0, 4.0);
        ground = this.getWorld().createBody(bd);
        vs = new Vec2[]{new Vec2(0.0, 0.0), new Vec2(6.0, 0.0), new Vec2(6.0, 2.0), new Vec2(4.0, 1.0), new Vec2(2.0, 2.0), new Vec2(0.0, 2.0), new Vec2(-2.0, 2.0), new Vec2(-4.0, 3.0), new Vec2(-6.0, 2.0), new Vec2(-6.0, 0.0)};
        shape2 = new ChainShape();
        shape2.createLoop(vs, 10);
        ground.createFixture((Shape)shape2, 0.0);
        bd = new BodyDef();
        bd.position.set(-3.0, 8.0);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        Body body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.5, 0.5);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 20.0;
        body.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(-5.0, 5.0);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.25, 0.25);
        fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 20.0;
        body.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(-5.0, 8.0);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        body = this.getWorld().createBody(bd);
        double angle = 0.0;
        double delta = 1.0471975511965976;
        Vec2[] vertices = new Vec2[6];
        for (int i = 0; i < 6; ++i) {
            vertices[i] = new Vec2(0.5 * MathUtils.cos((double)angle), 0.5 * MathUtils.sin((double)angle));
            angle += delta;
        }
        PolygonShape shape3 = new PolygonShape();
        shape3.set(vertices, 6);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = shape3;
        fd2.density = 20.0;
        body.createFixture(fd2);
        bd = new BodyDef();
        bd.position.set(3.0, 5.0);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        body = this.getWorld().createBody(bd);
        CircleShape shape22 = new CircleShape();
        shape22.m_radius = 0.5;
        fd = new FixtureDef();
        fd.shape = shape22;
        fd.density = 20.0;
        body.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(-7.0, 6.0);
        bd.type = BodyType.DYNAMIC;
        bd.allowSleep = false;
        this.m_character = this.getWorld().createBody(bd);
        CircleShape shape4 = new CircleShape();
        shape4.m_radius = 0.25;
        FixtureDef fd3 = new FixtureDef();
        fd3.shape = shape4;
        fd3.density = 20.0;
        fd3.friction = 1.0;
        this.m_character.createFixture(fd3);
    }

    @Override
    public void step(TestbedSettings settings) {
        Vec2 v = this.m_character.getLinearVelocity();
        v.x = -5.0;
        super.step(settings);
        this.addTextLine("This tests various character collision shapes");
        this.addTextLine("Limitation: square and hexagon can snag on aligned boxes.");
        this.addTextLine("Feature: edge chains have smooth collision inside and out.");
    }

    @Override
    public String getTestName() {
        return "Character Collision";
    }
}

