/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class Chain
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox((double)0.6f, 0.125);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 20.0;
        fd.friction = 0.2f;
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.collideConnected = false;
        double y = 25.0;
        Body prevBody = ground;
        for (int i = 0; i < 30; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set((double)(0.5f + (float)i), 25.0);
            Body body = this.getWorld().createBody(bd2);
            body.createFixture(fd);
            Vec2 anchor = new Vec2((double)i, 25.0);
            jd.initialize(prevBody, body, anchor);
            this.getWorld().createJoint((JointDef)jd);
            prevBody = body;
        }
    }

    @Override
    public String getTestName() {
        return "Chain";
    }
}

