/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.WheelJoint;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Car
extends TestbedTest {
    private static final long CAR_TAG = 100L;
    private static final long WHEEL1_TAG = 101L;
    private static final long WHEEL2_TAG = 102L;
    private static final long SPRING1_TAG = 103L;
    private static final long SPRING2_TAG = 104L;
    private Body m_car;
    private Body m_wheel1;
    private Body m_wheel2;
    private double m_hz;
    private double m_zeta;
    private double m_speed;
    private WheelJoint m_spring1;
    private WheelJoint m_spring2;

    @Override
    public Long getTag(Body body) {
        if (body == this.m_car) {
            return 100L;
        }
        if (body == this.m_wheel1) {
            return 101L;
        }
        if (body == this.m_wheel2) {
            return 102L;
        }
        return super.getTag(body);
    }

    @Override
    public Long getTag(Joint joint) {
        if (joint == this.m_spring1) {
            return 103L;
        }
        if (joint == this.m_spring2) {
            return 104L;
        }
        return super.getTag(joint);
    }

    @Override
    public void processBody(Body body, Long tag) {
        if (tag == 100L) {
            this.m_car = body;
        } else if (tag == 101L) {
            this.m_wheel1 = body;
        } else if (tag == 102L) {
            this.m_wheel2 = body;
        } else {
            super.processBody(body, tag);
        }
    }

    @Override
    public void processJoint(Joint joint, Long tag) {
        if (tag == 103L) {
            this.m_spring1 = (WheelJoint)joint;
        } else if (tag == 104L) {
            this.m_spring2 = (WheelJoint)joint;
        } else {
            super.processJoint(joint, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public String getTestName() {
        return "Car";
    }

    @Override
    public void initTest(boolean deserialized) {
        double y2;
        int i;
        if (deserialized) {
            return;
        }
        this.m_hz = 4.0;
        this.m_zeta = 0.7f;
        this.m_speed = 50.0;
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.m_world.createBody(bd);
        EdgeShape shape = new EdgeShape();
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 0.0;
        fd.friction = 0.6f;
        shape.set(new Vec2(-20.0, 0.0), new Vec2(20.0, 0.0));
        ground.createFixture(fd);
        double[] hs = new double[]{0.25, 1.0, 4.0, 0.0, 0.0, -1.0, -2.0, -2.0, -1.25, 0.0};
        double x = 20.0;
        double y1 = 0.0;
        double dx = 5.0;
        for (i = 0; i < 10; ++i) {
            y2 = hs[i];
            shape.set(new Vec2(x, y1), new Vec2(x + dx, y2));
            ground.createFixture(fd);
            y1 = y2;
            x += dx;
        }
        for (i = 0; i < 10; ++i) {
            y2 = hs[i];
            shape.set(new Vec2(x, y1), new Vec2(x + dx, y2));
            ground.createFixture(fd);
            y1 = y2;
            x += dx;
        }
        shape.set(new Vec2(x, 0.0), new Vec2(x + 40.0, 0.0));
        ground.createFixture(fd);
        shape.set(new Vec2(x += 80.0, 0.0), new Vec2(x + 40.0, 0.0));
        ground.createFixture(fd);
        shape.set(new Vec2(x += 40.0, 0.0), new Vec2(x + 10.0, 5.0));
        ground.createFixture(fd);
        shape.set(new Vec2(x += 20.0, 0.0), new Vec2(x + 40.0, 0.0));
        ground.createFixture(fd);
        shape.set(new Vec2(x += 40.0, 0.0), new Vec2(x, 20.0));
        ground.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(140.0, 1.0);
        bd.type = BodyType.DYNAMIC;
        Body body = this.m_world.createBody(bd);
        PolygonShape box = new PolygonShape();
        box.setAsBox(10.0, 0.25);
        body.createFixture((Shape)box, 1.0);
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.initialize(ground, body, body.getPosition());
        jd.lowerAngle = -0.13962634015954636;
        jd.upperAngle = 0.13962634015954636;
        jd.enableLimit = true;
        this.m_world.createJoint((JointDef)jd);
        body.applyAngularImpulse(100.0);
        int N = 20;
        shape = new PolygonShape();
        shape.setAsBox(1.0, 0.125);
        fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 1.0;
        fd.friction = 0.6f;
        jd = new RevoluteJointDef();
        Body prevBody = ground;
        for (int i2 = 0; i2 < N; ++i2) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set((double)(161.0f + 2.0f * (float)i2), -0.125);
            Body body2 = this.m_world.createBody(bd2);
            body2.createFixture(fd);
            Vec2 anchor = new Vec2((double)(160.0f + 2.0f * (float)i2), -0.125);
            jd.initialize(prevBody, body2, anchor);
            this.m_world.createJoint((JointDef)jd);
            prevBody = body2;
        }
        Vec2 anchor = new Vec2((double)(160.0f + 2.0f * (float)N), -0.125);
        jd.initialize(prevBody, ground, anchor);
        this.m_world.createJoint((JointDef)jd);
        PolygonShape box2 = new PolygonShape();
        box2.setAsBox(0.5, 0.5);
        body = null;
        BodyDef bd3 = new BodyDef();
        bd3.type = BodyType.DYNAMIC;
        bd3.position.set(230.0, 0.5);
        body = this.m_world.createBody(bd3);
        body.createFixture((Shape)box2, 0.5);
        bd3.position.set(230.0, 1.5);
        body = this.m_world.createBody(bd3);
        body.createFixture((Shape)box2, 0.5);
        bd3.position.set(230.0, 2.5);
        body = this.m_world.createBody(bd3);
        body.createFixture((Shape)box2, 0.5);
        bd3.position.set(230.0, 3.5);
        body = this.m_world.createBody(bd3);
        body.createFixture((Shape)box2, 0.5);
        bd3.position.set(230.0, 4.5);
        body = this.m_world.createBody(bd3);
        body.createFixture((Shape)box2, 0.5);
        PolygonShape chassis = new PolygonShape();
        Vec2[] vertices = new Vec2[8];
        vertices[0] = new Vec2(-1.5, -0.5);
        vertices[1] = new Vec2(1.5, -0.5);
        vertices[2] = new Vec2(1.5, 0.0);
        vertices[3] = new Vec2(0.0, (double)0.9f);
        vertices[4] = new Vec2((double)-1.15f, (double)0.9f);
        vertices[5] = new Vec2(-1.5, (double)0.2f);
        chassis.set(vertices, 6);
        CircleShape circle = new CircleShape();
        circle.m_radius = 0.4f;
        BodyDef bd4 = new BodyDef();
        bd4.type = BodyType.DYNAMIC;
        bd4.position.set(0.0, 1.0);
        this.m_car = this.m_world.createBody(bd4);
        this.m_car.createFixture((Shape)chassis, 1.0);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = circle;
        fd2.density = 1.0;
        fd2.friction = 0.9f;
        bd4.position.set(-1.0, (double)0.35f);
        this.m_wheel1 = this.m_world.createBody(bd4);
        this.m_wheel1.createFixture(fd2);
        bd4.position.set(1.0, (double)0.4f);
        this.m_wheel2 = this.m_world.createBody(bd4);
        this.m_wheel2.createFixture(fd2);
        WheelJointDef jd2 = new WheelJointDef();
        Vec2 axis = new Vec2(0.0, 1.0);
        jd2.initialize(this.m_car, this.m_wheel1, this.m_wheel1.getPosition(), axis);
        jd2.motorSpeed = 0.0;
        jd2.maxMotorTorque = 20.0;
        jd2.enableMotor = true;
        jd2.frequencyHz = this.m_hz;
        jd2.dampingRatio = this.m_zeta;
        this.m_spring1 = (WheelJoint)this.m_world.createJoint((JointDef)jd2);
        jd2.initialize(this.m_car, this.m_wheel2, this.m_wheel2.getPosition(), axis);
        jd2.motorSpeed = 0.0;
        jd2.maxMotorTorque = 10.0;
        jd2.enableMotor = false;
        jd2.frequencyHz = this.m_hz;
        jd2.dampingRatio = this.m_zeta;
        this.m_spring2 = (WheelJoint)this.m_world.createJoint((JointDef)jd2);
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'a': {
                this.m_spring1.enableMotor(true);
                this.m_spring1.setMotorSpeed(this.m_speed);
                break;
            }
            case 's': {
                this.m_spring1.enableMotor(true);
                this.m_spring1.setMotorSpeed(0.0);
                break;
            }
            case 'd': {
                this.m_spring1.enableMotor(true);
                this.m_spring1.setMotorSpeed(-this.m_speed);
                break;
            }
            case 'q': {
                this.m_hz = MathUtils.max((double)0.0, (double)(this.m_hz - 1.0));
                this.m_spring1.setSpringFrequencyHz(this.m_hz);
                this.m_spring2.setSpringFrequencyHz(this.m_hz);
                break;
            }
            case 'e': {
                this.m_hz += 1.0;
                this.m_spring1.setSpringFrequencyHz(this.m_hz);
                this.m_spring2.setSpringFrequencyHz(this.m_hz);
            }
        }
    }

    @Override
    public void keyReleased(char argKeyChar, int argKeyCode) {
        super.keyReleased(argKeyChar, argKeyCode);
        switch (argKeyChar) {
            case 'a': 
            case 'd': 
            case 's': {
                this.m_spring1.enableMotor(false);
            }
        }
    }

    @Override
    public double getDefaultCameraScale() {
        return 15.0;
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: left = a, brake = s, right = d, hz down = q, hz up = e");
        this.addTextLine("frequency = " + this.m_hz + " hz, damping ratio = " + this.m_zeta);
        this.getCamera().setCamera(this.m_car.getPosition());
    }
}

