/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class BulletTest
extends TestbedTest {
    Body m_body;
    Body m_bullet;
    double m_x;

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0, 6.0);
    }

    @Override
    public double getDefaultCameraScale() {
        return 40.0;
    }

    @Override
    public void initTest(boolean deserialized) {
        BodyDef bd = new BodyDef();
        bd.position.set(0.0, 0.0);
        Body body = this.m_world.createBody(bd);
        EdgeShape edge = new EdgeShape();
        edge.set(new Vec2(-10.0, 0.0), new Vec2(10.0, 0.0));
        body.createFixture((Shape)edge, 0.0);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox((double)0.2f, 1.0, new Vec2(0.5, 1.0), 0.0);
        body.createFixture((Shape)shape, 0.0);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 4.0);
        PolygonShape box = new PolygonShape();
        box.setAsBox(2.0, (double)0.1f);
        this.m_body = this.m_world.createBody(bd);
        this.m_body.createFixture((Shape)box, 1.0);
        box.setAsBox(0.25, 0.25);
        this.m_x = -0.06530576944351196;
        bd.position.set(this.m_x, 10.0);
        bd.bullet = true;
        this.m_bullet = this.m_world.createBody(bd);
        this.m_bullet.createFixture((Shape)box, 100.0);
        this.m_bullet.setLinearVelocity(new Vec2(0.0, -50.0));
    }

    public void launch() {
        this.m_body.setTransform(new Vec2(0.0, 4.0), 0.0);
        this.m_body.setLinearVelocity(new Vec2());
        this.m_body.setAngularVelocity(0.0);
        this.m_x = MathUtils.randomDouble((double)-1.0, (double)1.0);
        this.m_bullet.setTransform(new Vec2(this.m_x, 10.0), 0.0);
        this.m_bullet.setLinearVelocity(new Vec2(0.0, -50.0));
        this.m_bullet.setAngularVelocity(0.0);
        Distance.GJK_CALLS = 0;
        Distance.GJK_ITERS = 0;
        Distance.GJK_MAX_ITERS = 0;
        TimeOfImpact.toiCalls = 0;
        TimeOfImpact.toiIters = 0;
        TimeOfImpact.toiMaxIters = 0;
        TimeOfImpact.toiRootIters = 0;
        TimeOfImpact.toiMaxRootIters = 0;
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        if (Distance.GJK_CALLS > 0) {
            this.addTextLine(String.format("gjk calls = %d, ave gjk iters = %3.1f, max gjk iters = %d", Distance.GJK_CALLS, (double)Distance.GJK_ITERS * 1.0 / (double)Distance.GJK_CALLS, Distance.GJK_MAX_ITERS));
        }
        if (TimeOfImpact.toiCalls > 0) {
            this.addTextLine(String.format("toi calls = %d, ave toi iters = %3.1f, max toi iters = %d", TimeOfImpact.toiCalls, Float.valueOf((float)TimeOfImpact.toiIters * 1.0f / (float)TimeOfImpact.toiCalls), TimeOfImpact.toiMaxRootIters));
            this.addTextLine(String.format("ave toi root iters = %3.1f, max toi root iters = %d", Float.valueOf((float)TimeOfImpact.toiRootIters * 1.0f / (float)TimeOfImpact.toiCalls), TimeOfImpact.toiMaxRootIters));
        }
        if (this.getStepCount() % 60 == 0) {
            this.launch();
        }
    }

    @Override
    public String getTestName() {
        return "Bullet Test";
    }
}

