/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Breakable
extends TestbedTest {
    Body m_body1;
    Vec2 m_velocity = new Vec2();
    double m_angularVelocity;
    PolygonShape m_shape1;
    PolygonShape m_shape2;
    Fixture m_piece1;
    Fixture m_piece2;
    boolean m_broke;
    boolean m_break;

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 40.0);
        bd.angle = 0.7853981633974483;
        this.m_body1 = this.getWorld().createBody(bd);
        this.m_shape1 = new PolygonShape();
        this.m_shape1.setAsBox(0.5, 0.5, new Vec2(-0.5, 0.0), 0.0);
        this.m_piece1 = this.m_body1.createFixture((Shape)this.m_shape1, 1.0);
        this.m_shape2 = new PolygonShape();
        this.m_shape2.setAsBox(0.5, 0.5, new Vec2(0.5, 0.0), 0.0);
        this.m_piece2 = this.m_body1.createFixture((Shape)this.m_shape2, 1.0);
        this.m_break = false;
        this.m_broke = false;
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
        if (this.m_broke) {
            return;
        }
        int count = contact.getManifold().pointCount;
        double maxImpulse = 0.0;
        for (int i = 0; i < count; ++i) {
            maxImpulse = MathUtils.max((double)maxImpulse, (double)impulse.normalImpulses[i]);
        }
        if (maxImpulse > 40.0) {
            this.m_break = true;
        }
    }

    void Break() {
        Body body1 = this.m_piece1.getBody();
        Vec2 center = body1.getWorldCenter();
        body1.destroyFixture(this.m_piece2);
        this.m_piece2 = null;
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position = body1.getPosition();
        bd.angle = body1.getAngle();
        Body body2 = this.getWorld().createBody(bd);
        this.m_piece2 = body2.createFixture((Shape)this.m_shape2, 1.0);
        Vec2 center1 = body1.getWorldCenter();
        Vec2 center2 = body2.getWorldCenter();
        Vec2 velocity1 = this.m_velocity.add(Vec2.cross((double)this.m_angularVelocity, (Vec2)center1.sub(center)));
        Vec2 velocity2 = this.m_velocity.add(Vec2.cross((double)this.m_angularVelocity, (Vec2)center2.sub(center)));
        body1.setAngularVelocity(this.m_angularVelocity);
        body1.setLinearVelocity(velocity1);
        body2.setAngularVelocity(this.m_angularVelocity);
        body2.setLinearVelocity(velocity2);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        if (this.m_break) {
            this.Break();
            this.m_broke = true;
            this.m_break = false;
        }
        if (!this.m_broke) {
            this.m_velocity.set(this.m_body1.getLinearVelocity());
            this.m_angularVelocity = this.m_body1.getAngularVelocity();
        }
    }

    @Override
    public String getTestName() {
        return "Breakable";
    }
}

