/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class BodyTypes
extends TestbedTest {
    private static final long ATTACHMENT_TAG = 19L;
    private static final long PLATFORM_TAG = 20L;
    Body m_attachment;
    Body m_platform;
    double m_speed;

    @Override
    public Long getTag(Body body) {
        if (body == this.m_attachment) {
            return 19L;
        }
        if (body == this.m_platform) {
            return 20L;
        }
        return super.getTag(body);
    }

    @Override
    public void processBody(Body body, Long tag) {
        if (tag == 19L) {
            this.m_attachment = body;
        } else if (tag == 20L) {
            this.m_platform = body;
        } else {
            super.processBody(body, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        this.m_speed = 3.0;
        if (deserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-20.0, 0.0), new Vec2(20.0, 0.0));
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        ground.createFixture(fd);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 3.0);
        this.m_attachment = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.5, 2.0);
        this.m_attachment.createFixture((Shape)shape, 2.0);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(-4.0, 5.0);
        this.m_platform = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.5, 4.0, new Vec2(4.0, 0.0), 1.5707963267948966);
        fd = new FixtureDef();
        fd.shape = shape;
        fd.friction = 0.6f;
        fd.density = 2.0;
        this.m_platform.createFixture(fd);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(this.m_attachment, this.m_platform, new Vec2(0.0, 5.0));
        rjd.maxMotorTorque = 50.0;
        rjd.enableMotor = true;
        this.getWorld().createJoint((JointDef)rjd);
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(ground, this.m_platform, new Vec2(0.0, 5.0), new Vec2(1.0, 0.0));
        pjd.maxMotorForce = 1000.0;
        pjd.enableMotor = true;
        pjd.lowerTranslation = -10.0;
        pjd.upperTranslation = 10.0;
        pjd.enableLimit = true;
        this.getWorld().createJoint((JointDef)pjd);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0, 8.0);
        Body body = this.getWorld().createBody(bd);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.75, 0.75);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = shape2;
        fd2.friction = 0.6f;
        fd2.density = 2.0;
        body.createFixture(fd2);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (d) dynamic, (s) static, (k) kinematic");
        if (this.m_platform.getType() == BodyType.KINEMATIC) {
            Vec2 p = this.m_platform.getTransform().p;
            Vec2 v = this.m_platform.getLinearVelocity();
            if (p.x < -10.0 && v.x < 0.0 || p.x > 10.0 && v.x > 0.0) {
                v.x = -v.x;
                this.m_platform.setLinearVelocity(v);
            }
        }
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'd': {
                this.m_platform.setType(BodyType.DYNAMIC);
                break;
            }
            case 's': {
                this.m_platform.setType(BodyType.STATIC);
                break;
            }
            case 'k': {
                this.m_platform.setType(BodyType.KINEMATIC);
                this.m_platform.setLinearVelocity(new Vec2(-this.m_speed, 0.0));
                this.m_platform.setAngularVelocity(0.0);
            }
        }
    }

    @Override
    public String getTestName() {
        return "Body Types";
    }
}

