/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class BlobTest4
extends TestbedTest {
    @Override
    public double getDefaultCameraScale() {
        return 20.0;
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        Body ground = null;
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(50.0, (double)0.4f);
        BodyDef bd = new BodyDef();
        bd.position.set(0.0, 0.0);
        ground = this.getWorld().createBody(bd);
        ground.createFixture((Shape)sd, 0.0);
        sd.setAsBox((double)0.4f, 50.0, new Vec2(-10.0, 0.0), 0.0);
        ground.createFixture((Shape)sd, 0.0);
        sd.setAsBox((double)0.4f, 50.0, new Vec2(10.0, 0.0), 0.0);
        ground.createFixture((Shape)sd, 0.0);
        ConstantVolumeJointDef cvjd = new ConstantVolumeJointDef();
        double cx = 0.0;
        double cy = 10.0;
        double rx = 5.0;
        double ry = 5.0;
        int nBodies = 20;
        double bodyRadius = 0.5;
        for (int i = 0; i < nBodies; ++i) {
            double angle = MathUtils.map((double)i, (double)0.0, (double)nBodies, (double)0.0, (double)6.283f);
            BodyDef bd2 = new BodyDef();
            bd2.fixedRotation = true;
            double x = cx + rx * Math.sin(angle);
            double y = cy + ry * Math.cos(angle);
            bd2.position.set(new Vec2(x, y));
            bd2.type = BodyType.DYNAMIC;
            Body body = this.getWorld().createBody(bd2);
            FixtureDef fd = new FixtureDef();
            CircleShape cd = new CircleShape();
            cd.m_radius = bodyRadius;
            fd.shape = cd;
            fd.density = 1.0;
            body.createFixture(fd);
            cvjd.addBody(body);
        }
        cvjd.frequencyHz = 10.0;
        cvjd.dampingRatio = 1.0;
        cvjd.collideConnected = false;
        this.getWorld().createJoint((JointDef)cvjd);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        PolygonShape psd = new PolygonShape();
        psd.setAsBox(3.0, 1.5, new Vec2(cx, cy + 15.0), 0.0);
        bd2.position = new Vec2(cx, cy + 15.0);
        Body fallingBox = this.getWorld().createBody(bd2);
        fallingBox.createFixture((Shape)psd, 1.0);
    }

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0, 10.0);
    }

    @Override
    public String getTestName() {
        return "Blob Joint";
    }
}

