/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ApplyForce
extends TestbedTest {
    private static final long BODY_TAG = 12L;
    Body m_body;

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        this.getWorld().setGravity(new Vec2(0.0, 0.0));
        double k_restitution = 0.4f;
        BodyDef bd = new BodyDef();
        bd.position.set(0.0, 20.0);
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        FixtureDef sd = new FixtureDef();
        sd.shape = shape;
        sd.density = 0.0;
        sd.restitution = 0.4f;
        shape.set(new Vec2(-20.0, -20.0), new Vec2(-20.0, 20.0));
        ground.createFixture(sd);
        shape.set(new Vec2(20.0, -20.0), new Vec2(20.0, 20.0));
        ground.createFixture(sd);
        shape.set(new Vec2(-20.0, 20.0), new Vec2(20.0, 20.0));
        ground.createFixture(sd);
        shape.set(new Vec2(-20.0, -20.0), new Vec2(20.0, -20.0));
        ground.createFixture(sd);
        Transform xf1 = new Transform();
        xf1.q.set(1.10709726640493);
        Rot.mulToOutUnsafe((Rot)xf1.q, (Vec2)new Vec2(1.0, 0.0), (Vec2)xf1.p);
        Vec2[] vertices = new Vec2[]{Transform.mul((Transform)xf1, (Vec2)new Vec2(-1.0, 0.0)), Transform.mul((Transform)xf1, (Vec2)new Vec2(1.0, 0.0)), Transform.mul((Transform)xf1, (Vec2)new Vec2(0.0, 0.5))};
        PolygonShape poly1 = new PolygonShape();
        poly1.set(vertices, 3);
        FixtureDef sd1 = new FixtureDef();
        sd1.shape = poly1;
        sd1.density = 4.0;
        Transform xf2 = new Transform();
        xf2.q.set(-1.10709726640493);
        Rot.mulToOut((Rot)xf2.q, (Vec2)new Vec2(-1.0, 0.0), (Vec2)xf2.p);
        vertices[0] = Transform.mul((Transform)xf2, (Vec2)new Vec2(-1.0, 0.0));
        vertices[1] = Transform.mul((Transform)xf2, (Vec2)new Vec2(1.0, 0.0));
        vertices[2] = Transform.mul((Transform)xf2, (Vec2)new Vec2(0.0, 0.5));
        PolygonShape poly2 = new PolygonShape();
        poly2.set(vertices, 3);
        FixtureDef sd2 = new FixtureDef();
        sd2.shape = poly2;
        sd2.density = 2.0;
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.angularDamping = 2.0;
        bd2.linearDamping = 0.5;
        bd2.position.set(0.0, 2.0);
        bd2.angle = Math.PI;
        bd2.allowSleep = false;
        this.m_body = this.getWorld().createBody(bd2);
        this.m_body.createFixture(sd1);
        this.m_body.createFixture(sd2);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.5, 0.5);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 1.0;
        fd.friction = 0.3f;
        for (int i = 0; i < 10; ++i) {
            BodyDef bd3 = new BodyDef();
            bd3.type = BodyType.DYNAMIC;
            bd3.position.set(0.0, (double)(5.0f + 1.54f * (float)i));
            Body body = this.getWorld().createBody(bd3);
            body.createFixture(fd);
            double gravity = 10.0;
            double I = body.getInertia();
            double mass = body.getMass();
            double radius = MathUtils.sqrt((double)(2.0 * I / mass));
            FrictionJointDef jd = new FrictionJointDef();
            jd.localAnchorA.setZero();
            jd.localAnchorB.setZero();
            jd.bodyA = ground;
            jd.bodyB = body;
            jd.collideConnected = true;
            jd.maxForce = mass * gravity;
            jd.maxTorque = mass * radius * gravity;
            this.getWorld().createJoint((JointDef)jd);
        }
    }

    @Override
    public void keyPressed(char keyCar, int keyCode) {
        super.keyPressed(keyCar, keyCode);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Use 'wasd' to move, 'e' and 's' drift.");
        if (this.getModel().getKeys()[119]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0, -30.0));
            Vec2 p = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(0.0, 2.0)));
            this.m_body.applyForce(f, p);
        } else if (this.getModel().getKeys()[113]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0, -30.0));
            Vec2 p = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2((double)-0.2f, 0.0)));
            this.m_body.applyForce(f, p);
        } else if (this.getModel().getKeys()[101]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0, -30.0));
            Vec2 p = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2((double)0.2f, 0.0)));
            this.m_body.applyForce(f, p);
        } else if (this.getModel().getKeys()[115]) {
            Vec2 f = this.m_body.getWorldVector(new Vec2(0.0, 30.0));
            Vec2 p = this.m_body.getWorldCenter();
            this.m_body.applyForce(f, p);
        }
        if (this.getModel().getKeys()[97]) {
            this.m_body.applyTorque(20.0);
        }
        if (this.getModel().getKeys()[100]) {
            this.m_body.applyTorque(-20.0);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public Long getTag(Body body) {
        if (body == this.m_body) {
            return 12L;
        }
        return super.getTag(body);
    }

    @Override
    public void processBody(Body body, Long tag) {
        if (tag == 12L) {
            this.m_body = body;
        }
        super.processBody(body, tag);
    }

    @Override
    public String getTestName() {
        return "Apply Force";
    }
}

