/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.normal.DefaultWorldPool;
import org.jbox2d.profile.BasicPerformanceTest;

public class StackTest
extends BasicPerformanceTest {
    public static final int INNER_ITERS = 50000;
    public static final int OUTER_ITERS = 200;
    public static String[] tests = new String[]{"Pop2Sep", "Pop2Cont", "Pop3Sep", "Pop3Cont", "Pop4Sep", "Pop4Cont", "Pop9Sep", "Pop9Cont"};
    public static double aStore = 0.0;
    private final IWorldPool wp = new DefaultWorldPool(100, 10);

    public StackTest() {
        super(8, 200, 50000);
    }

    public double op(Vec2 argVec) {
        argVec.set(MathUtils.randomDouble((double)-100.0, (double)100.0), MathUtils.randomDouble((double)-100.0, (double)100.0));
        argVec.mulLocal((double)3.2f);
        double s = argVec.length();
        argVec.normalize();
        return s;
    }

    @Override
    public void step(int argNum) {
        double a = 0.0;
        block10: for (int i = 0; i < 50000; ++i) {
            switch (argNum) {
                case 0: {
                    Vec2 v1 = this.wp.popVec2();
                    Vec2 v2 = this.wp.popVec2();
                    a += this.op(v1);
                    a += this.op(v2);
                    this.wp.pushVec2(2);
                    continue block10;
                }
                case 1: {
                    Vec2[] pc = this.wp.popVec2(2);
                    a += this.op(pc[0]);
                    a += this.op(pc[1]);
                    this.wp.pushVec2(2);
                    continue block10;
                }
                case 2: {
                    Vec2 v1 = this.wp.popVec2();
                    Vec2 v2 = this.wp.popVec2();
                    Vec2 v3 = this.wp.popVec2();
                    a += this.op(v1);
                    a += this.op(v2);
                    a += this.op(v3);
                    this.wp.pushVec2(3);
                    continue block10;
                }
                case 3: {
                    Vec2[] pc = this.wp.popVec2(3);
                    a += this.op(pc[0]);
                    a += this.op(pc[1]);
                    a += this.op(pc[2]);
                    this.wp.pushVec2(3);
                    continue block10;
                }
                case 4: {
                    Vec2 v1 = this.wp.popVec2();
                    Vec2 v2 = this.wp.popVec2();
                    Vec2 v3 = this.wp.popVec2();
                    Vec2 v4 = this.wp.popVec2();
                    a += this.op(v1);
                    a += this.op(v2);
                    a += this.op(v3);
                    a += this.op(v4);
                    this.wp.pushVec2(4);
                    continue block10;
                }
                case 5: {
                    Vec2[] pc = this.wp.popVec2(4);
                    a += this.op(pc[0]);
                    a += this.op(pc[1]);
                    a += this.op(pc[2]);
                    a += this.op(pc[3]);
                    this.wp.pushVec2(4);
                    continue block10;
                }
                case 6: {
                    Vec2 v1 = this.wp.popVec2();
                    Vec2 v2 = this.wp.popVec2();
                    Vec2 v3 = this.wp.popVec2();
                    Vec2 v4 = this.wp.popVec2();
                    Vec2 v5 = this.wp.popVec2();
                    Vec2 v6 = this.wp.popVec2();
                    Vec2 v7 = this.wp.popVec2();
                    Vec2 v8 = this.wp.popVec2();
                    Vec2 v9 = this.wp.popVec2();
                    a += this.op(v1);
                    a += this.op(v2);
                    a += this.op(v3);
                    a += this.op(v4);
                    a += this.op(v5);
                    a += this.op(v6);
                    a += this.op(v7);
                    a += this.op(v8);
                    a += this.op(v9);
                    this.wp.pushVec2(9);
                    continue block10;
                }
                case 7: {
                    Vec2[] pc = this.wp.popVec2(9);
                    a += this.op(pc[0]);
                    a += this.op(pc[1]);
                    a += this.op(pc[2]);
                    a += this.op(pc[3]);
                    a += this.op(pc[4]);
                    a += this.op(pc[5]);
                    a += this.op(pc[6]);
                    a += this.op(pc[7]);
                    a += this.op(pc[8]);
                    this.wp.pushVec2(9);
                    continue block10;
                }
            }
        }
        aStore += a;
    }

    @Override
    public String getTestName(int argNum) {
        return tests[argNum];
    }

    public static void main(String[] c) {
        new StackTest().go();
    }
}

