/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.normal.DefaultWorldPool;
import org.jbox2d.profile.BasicPerformanceTest;

public class PoolingPerf
extends BasicPerformanceTest {
    public static final int INNER_ITERS = 50000;
    public static final int OUTER_ITERS = 1000;
    public String[] tests = new String[]{"Creation", "World Pool", "Circle Pool", "Custom Stack", "ThreadLocal member", "Member"};
    public double aStore = 0.0;
    public IWorldPool wp = new DefaultWorldPool(100, 10);
    public CirclePool cp = new CirclePool();
    public TLVec2 tlv = new TLVec2();
    public Vec2 mv = new Vec2();
    public CustStack stack = new CustStack();

    public PoolingPerf() {
        super(6, 1000, 50000);
    }

    public double op(Vec2 argVec) {
        argVec.set(MathUtils.randomDouble((double)-100.0, (double)100.0), MathUtils.randomDouble((double)-100.0, (double)100.0));
        argVec.mulLocal((double)3.2f);
        double s = argVec.length();
        argVec.normalize();
        return s;
    }

    @Override
    public void step(int argNum) {
        switch (argNum) {
            case 0: {
                this.runCreationTest();
                break;
            }
            case 1: {
                this.runWorldPoolTest();
                break;
            }
            case 2: {
                this.runCirclePoolTest();
                break;
            }
            case 3: {
                this.runCustStackTest();
                break;
            }
            case 4: {
                this.runThreadLocalTest();
                break;
            }
            case 5: {
                this.runMemberTest();
            }
        }
    }

    public void runCreationTest() {
        double a = 0.0;
        for (int i = 0; i < 50000; ++i) {
            Vec2 v = new Vec2();
            a += this.op(v);
        }
        this.aStore += a;
    }

    public void runWorldPoolTest() {
        double a = 0.0;
        for (int i = 0; i < 50000; ++i) {
            Vec2 v = this.wp.popVec2();
            a += this.op(v);
            this.wp.pushVec2(1);
        }
        this.aStore += a;
    }

    public void runCirclePoolTest() {
        double a = 0.0;
        for (int i = 0; i < 50000; ++i) {
            Vec2 v = this.cp.get();
            a += this.op(v);
        }
        this.aStore += a;
    }

    public void runThreadLocalTest() {
        double a = 0.0;
        for (int i = 0; i < 50000; ++i) {
            Vec2 v = (Vec2)this.tlv.get();
            a += this.op(v);
        }
        this.aStore += a;
    }

    public void runCustStackTest() {
        double a = 0.0;
        for (int i = 0; i < 50000; ++i) {
            Vec2 v = this.stack.get();
            a += this.op(v);
            this.stack.reduce(1);
        }
        this.aStore += a;
    }

    public void runMemberTest() {
        double a = 0.0;
        for (int i = 0; i < 50000; ++i) {
            a += this.op(this.mv);
        }
        this.aStore += a;
    }

    @Override
    public String getTestName(int argNum) {
        return this.tests[argNum];
    }

    public static void main(String[] c) {
        PoolingPerf p = new PoolingPerf();
        p.go();
    }

    public static class TLVec2
    extends ThreadLocal<Vec2> {
        @Override
        protected Vec2 initialValue() {
            return new Vec2();
        }
    }

    public static class CustStack {
        final Vec2[] pool = new Vec2[50];
        int index;

        public CustStack() {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new Vec2();
            }
            this.index = 0;
        }

        public final Vec2 get() {
            return this.pool[this.index++];
        }

        public final void reduce(int i) {
            this.index -= i;
        }
    }

    public static class CirclePool {
        final Vec2[] pool = new Vec2[200];
        int index;
        final int length;

        public CirclePool() {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new Vec2();
            }
            this.length = 200;
            this.index = -1;
        }

        public final Vec2 get() {
            ++this.index;
            if (this.index >= this.length) {
                this.index = 0;
            }
            return this.pool[this.index];
        }
    }
}

