/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

import org.jbox2d.common.MathUtils;
import org.jbox2d.profile.BasicPerformanceTest;

public class MathPerf
extends BasicPerformanceTest {
    public static int INNER_ITERS = 5000;
    public static int OUTER_ITERS = 5000;
    String[] tests = new String[]{"Sin", "SinLUT", "Pow", "FastPow", "Max", "FastMax", "Floor", "fastFloor", "aTan2", "fastATan2", "ceil", "fastCeil"};
    public double aStore = 0.0;

    public MathPerf() {
        super(12, OUTER_ITERS, INNER_ITERS);
    }

    @Override
    public void step(int argNum) {
        double random = MathUtils.randomDouble((double)-5.992310449541053E307, (double)5.992310449541053E307);
        switch (argNum) {
            case 0: {
                this.runSinTest(random);
                break;
            }
            case 1: {
                this.runSinLUTTest(random);
                break;
            }
            case 2: {
                this.runPowTest(random);
                break;
            }
            case 3: {
                this.runFastPowTest(random);
                break;
            }
            case 4: {
                this.runMaxTest(random);
                break;
            }
            case 5: {
                this.runFastMaxTest(random);
                break;
            }
            case 6: {
                this.runFloorTest(random);
                break;
            }
            case 7: {
                this.runFastFloorTest(random);
                break;
            }
            case 8: {
                this.runAtan2Test(random);
                break;
            }
            case 9: {
                this.runFastAtan2Test(random);
                break;
            }
            case 10: {
                this.runCeilTest(random);
                break;
            }
            case 11: {
                this.runFastCeilTest(random);
            }
        }
    }

    public void runSinTest(double argRandom) {
        double a = StrictMath.sin(argRandom);
        this.aStore += a;
    }

    public void runSinLUTTest(double argRandom) {
        double a = MathUtils.sinLUT((double)argRandom);
        this.aStore += a;
    }

    public void runPowTest(double argRandom) {
        double a = StrictMath.pow(argRandom, MathUtils.randomDouble((double)-100.0, (double)100.0));
        this.aStore += a;
    }

    public void runFastPowTest(double argRandom) {
        double a = MathUtils.fastPow((double)argRandom, (double)MathUtils.randomDouble((double)-100.0, (double)100.0));
        this.aStore += a;
    }

    public void runMaxTest(double argRandom) {
        double a = StrictMath.max(argRandom, MathUtils.randomDouble((double)-100.0, (double)100.0));
        this.aStore += a;
    }

    public void runFastMaxTest(double argRandom) {
        double a = MathUtils.max((double)argRandom, (double)MathUtils.randomDouble((double)-100.0, (double)100.0));
        this.aStore += a;
    }

    public void runFloorTest(double argRandom) {
        double a = StrictMath.floor(argRandom);
        this.aStore += a;
    }

    public void runFastFloorTest(double argRandom) {
        double a = MathUtils.fastFloor((double)argRandom);
        this.aStore += a;
    }

    public void runAtan2Test(double argRandom) {
        double a = StrictMath.atan2(argRandom, MathUtils.randomDouble((double)-10000.0, (double)10000.0));
        this.aStore += a;
    }

    public void runFastAtan2Test(double argRandom) {
        double a = MathUtils.fastAtan2((double)argRandom, (double)MathUtils.randomDouble((double)-10000.0, (double)10000.0));
        this.aStore += a;
    }

    public void runCeilTest(double argRandom) {
        double a = StrictMath.ceil(argRandom);
        this.aStore += a;
    }

    public void runFastCeilTest(double argRandom) {
        double a = MathUtils.fastCeil((double)argRandom);
        this.aStore += a;
    }

    @Override
    public String getTestName(int argNum) {
        return this.tests[argNum];
    }

    public static void main(String[] c) {
        MathPerf p = new MathPerf();
        p.go();
    }
}

