/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jbox2d.testbed.framework.AbstractTestbedController;
import org.jbox2d.testbed.framework.TestList;
import org.jbox2d.testbed.framework.TestbedController;
import org.jbox2d.testbed.framework.TestbedErrorHandler;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.j2d.DebugDrawJ2D;
import org.jbox2d.testbed.framework.j2d.TestPanelJ2D;
import org.jbox2d.testbed.framework.j2d.TestbedSidePanel;

public class TestbedMain {
    public static void main(String[] args) {
        TestbedModel model = new TestbedModel();
        final TestbedController controller = new TestbedController(model, AbstractTestbedController.UpdateBehavior.UPDATE_CALLED, AbstractTestbedController.MouseBehavior.NORMAL, new TestbedErrorHandler(){

            @Override
            public void serializationError(Exception e, String message) {
                JOptionPane.showMessageDialog(null, message, "Serialization Error", 0);
            }
        });
        TestPanelJ2D panel = new TestPanelJ2D(model, controller);
        model.setPanel(panel);
        model.setDebugDraw(new DebugDrawJ2D(panel, true));
        TestList.populateModel(model);
        JFrame testbed = new JFrame();
        testbed.setTitle("JBox2D Testbed");
        testbed.setLayout(new BorderLayout());
        TestbedSidePanel side = new TestbedSidePanel(model, controller);
        testbed.add((Component)panel, "Center");
        testbed.add((Component)new JScrollPane(side), "East");
        testbed.pack();
        testbed.setVisible(true);
        testbed.setDefaultCloseOperation(3);
        System.out.println(System.getProperty("java.home"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                controller.playTest(0);
                controller.start();
            }
        });
    }
}

