/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import org.jbox2d.testbed.framework.AbstractTestbedController;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedPanel;
import org.jbox2d.testbed.framework.j2d.AWTPanelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPanelJ2D
extends JPanel
implements TestbedPanel {
    private static final Logger log = LoggerFactory.getLogger(TestPanelJ2D.class);
    public static final int SCREEN_DRAG_BUTTON = 3;
    public static final int INIT_WIDTH = 600;
    public static final int INIT_HEIGHT = 600;
    private Graphics2D dbg = null;
    private Image dbImage = null;
    private int panelWidth;
    private int panelHeight;
    private final AbstractTestbedController controller;

    public TestPanelJ2D(TestbedModel model, AbstractTestbedController controller) {
        this.controller = controller;
        this.setBackground(Color.black);
        this.setPreferredSize(new Dimension(600, 600));
        this.updateSize(600, 600);
        AWTPanelHelper.addHelpAndPanelListeners(this, model, controller, 3);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TestPanelJ2D.this.updateSize(TestPanelJ2D.this.getWidth(), TestPanelJ2D.this.getHeight());
                TestPanelJ2D.this.dbImage = null;
            }
        });
    }

    public Graphics2D getDBGraphics() {
        return this.dbg;
    }

    private void updateSize(int width, int height) {
        this.panelWidth = width;
        this.panelHeight = height;
        this.controller.updateExtents(width / 2, height / 2);
    }

    @Override
    public boolean render() {
        if (this.dbImage == null) {
            log.debug("dbImage is null, creating a new one");
            if (this.panelWidth <= 0 || this.panelHeight <= 0) {
                return false;
            }
            this.dbImage = this.createImage(this.panelWidth, this.panelHeight);
            if (this.dbImage == null) {
                log.error("dbImage is still null, ignoring render call");
                return false;
            }
            this.dbg = (Graphics2D)this.dbImage.getGraphics();
            this.dbg.setFont(new Font("Courier New", 0, 12));
        }
        this.dbg.setColor(Color.black);
        this.dbg.fillRect(0, 0, this.panelWidth, this.panelHeight);
        return true;
    }

    @Override
    public void paintScreen() {
        try {
            Graphics g = this.getGraphics();
            if (g != null && this.dbImage != null) {
                g.drawImage(this.dbImage, 0, 0, null);
                Toolkit.getDefaultToolkit().sync();
                g.dispose();
            }
        }
        catch (AWTError e) {
            log.error("Graphics context error", (Throwable)e);
        }
    }
}

