/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.collision.AABB;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.pooling.arrays.IntArray;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.testbed.framework.j2d.TestPanelJ2D;
import org.jbox2d.testbed.pooling.ColorPool;

public class DebugDrawJ2D
extends DebugDraw {
    public static int circlePoints = 13;
    public static final double edgeWidth = (double)0.02f;
    private final TestPanelJ2D panel;
    private final ColorPool<Color> cpool = new ColorPool<Color>(){

        @Override
        protected Color newColor(double r, double g, double b, double alpha) {
            return new Color((float)r, (float)g, (float)b, (float)alpha);
        }
    };
    private final boolean yFlip;
    private final BasicStroke stroke;
    private final Shape circle;
    private final Vec2Array vec2Array = new Vec2Array();
    private final Vec2 sp1 = new Vec2();
    private final Vec2 sp2 = new Vec2();
    private final AffineTransform tr = new AffineTransform();
    private AffineTransform oldTrans = new AffineTransform();
    private Stroke oldStroke;
    private final Vec2 zero = new Vec2();
    private final Color pcolorA = new Color(1.0f, 1.0f, 1.0f, 0.4f);
    private final Color pcolor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final Vec2 temp = new Vec2();
    private static final IntArray xIntsPool = new IntArray();
    private static final IntArray yIntsPool = new IntArray();
    private final Vec2 temp2 = new Vec2();

    public DebugDrawJ2D(TestPanelJ2D argTestPanel, boolean yFlip) {
        this.panel = argTestPanel;
        this.yFlip = yFlip;
        this.stroke = new BasicStroke(0.0f);
        this.circle = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
    }

    public void setViewportTransform(IViewportTransform viewportTransform) {
        super.setViewportTransform(viewportTransform);
        viewportTransform.setYFlip(this.yFlip);
    }

    public void drawPoint(Vec2 argPoint, double argRadiusOnScreen, Color3f argColor) {
        this.getWorldToScreenToOut(argPoint, this.sp1);
        Graphics2D g = this.getGraphics();
        Color c = this.cpool.getColor(argColor.x, argColor.y, argColor.z);
        g.setColor(c);
        this.sp1.x -= argRadiusOnScreen;
        this.sp1.y -= argRadiusOnScreen;
        g.fillOval((int)this.sp1.x, (int)this.sp1.y, (int)argRadiusOnScreen * 2, (int)argRadiusOnScreen * 2);
    }

    public void drawSegment(Vec2 p1, Vec2 p2, Color3f color) {
        this.getWorldToScreenToOut(p1, this.sp1);
        this.getWorldToScreenToOut(p2, this.sp2);
        Color c = this.cpool.getColor(color.x, color.y, color.z);
        Graphics2D g = this.getGraphics();
        g.setColor(c);
        g.setStroke(this.stroke);
        g.drawLine((int)this.sp1.x, (int)this.sp1.y, (int)this.sp2.x, (int)this.sp2.y);
    }

    public void drawAABB(AABB argAABB, Color3f color) {
        Vec2[] vecs = this.vec2Array.get(4);
        argAABB.getVertices(vecs);
        this.drawPolygon(vecs, 4, color);
    }

    private void saveState(Graphics2D g) {
        this.oldTrans = g.getTransform();
        this.oldStroke = g.getStroke();
    }

    private void restoreState(Graphics2D g) {
        g.setTransform(this.oldTrans);
        g.setStroke(this.oldStroke);
    }

    private void transformGraphics(Graphics2D g, Vec2 center) {
        Vec2 e = this.viewportTransform.getExtents();
        Vec2 vc = this.viewportTransform.getCenter();
        Mat22 vt = this.viewportTransform.getMat22Representation();
        int flip = this.yFlip ? -1 : 1;
        this.tr.setTransform(vt.ex.x, (double)flip * vt.ex.y, vt.ey.x, (double)flip * vt.ey.y, e.x, e.y);
        this.tr.translate(-vc.x, -vc.y);
        this.tr.translate(center.x, center.y);
        g.transform(this.tr);
    }

    public void drawCircle(Vec2 center, double radius, Color3f color) {
        Graphics2D g = this.getGraphics();
        Color s = this.cpool.getColor(color.x, color.y, color.z, 1.0);
        this.saveState(g);
        this.transformGraphics(g, center);
        g.setStroke(this.stroke);
        g.scale(radius, radius);
        g.setColor(s);
        g.drawOval(-1, -1, 2, 2);
        this.restoreState(g);
    }

    public void drawCircle(Vec2 center, double radius, Vec2 axis, Color3f color) {
        Graphics2D g = this.getGraphics();
        this.saveState(g);
        this.transformGraphics(g, center);
        g.setStroke(this.stroke);
        Color s = this.cpool.getColor(color.x, color.y, color.z, 1.0);
        g.scale(radius, radius);
        g.setColor(s);
        g.draw(this.circle);
        if (axis != null) {
            g.rotate(MathUtils.atan2((double)axis.y, (double)axis.x));
            g.drawLine(0, 0, 1, 0);
        }
        this.restoreState(g);
    }

    public void drawSolidCircle(Vec2 center, double radius, Vec2 axis, Color3f color) {
        Graphics2D g = this.getGraphics();
        this.saveState(g);
        this.transformGraphics(g, center);
        g.setStroke(this.stroke);
        Color f = this.cpool.getColor(color.x, color.y, color.z, 0.4f);
        Color s = this.cpool.getColor(color.x, color.y, color.z, 1.0);
        g.scale(radius, radius);
        g.setColor(f);
        g.fill(this.circle);
        g.setColor(s);
        g.draw(this.circle);
        if (axis != null) {
            g.rotate(MathUtils.atan2((double)axis.y, (double)axis.x));
            g.drawLine(0, 0, 1, 0);
        }
        this.restoreState(g);
    }

    public void drawParticles(Vec2[] centers, double radius, ParticleColor[] colors, int count) {
        Graphics2D g = this.getGraphics();
        this.saveState(g);
        this.transformGraphics(g, this.zero);
        g.setStroke(this.stroke);
        for (int i = 0; i < count; ++i) {
            Color color;
            Vec2 center = centers[i];
            if (colors == null) {
                color = this.pcolorA;
            } else {
                ParticleColor c = colors[i];
                color = this.cpool.getColor((float)c.r * 1.0f / 127.0f, (float)c.g * 1.0f / 127.0f, (float)c.b * 1.0f / 127.0f, (float)c.a * 1.0f / 127.0f);
            }
            AffineTransform old = g.getTransform();
            g.translate(center.x, center.y);
            g.scale(radius, radius);
            g.setColor(color);
            g.fill(this.circle);
            g.setTransform(old);
        }
        this.restoreState(g);
    }

    public void drawParticlesWireframe(Vec2[] centers, double radius, ParticleColor[] colors, int count) {
        Graphics2D g = this.getGraphics();
        this.saveState(g);
        this.transformGraphics(g, this.zero);
        g.setStroke(this.stroke);
        for (int i = 0; i < count; ++i) {
            Color color;
            Vec2 center = centers[i];
            if (colors == null) {
                color = this.pcolor;
            } else {
                ParticleColor c = colors[i];
                color = new Color((float)c.r * 1.0f / 127.0f, (float)c.g * 1.0f / 127.0f, (float)c.b * 1.0f / 127.0f, 1.0f);
            }
            AffineTransform old = g.getTransform();
            g.translate(center.x, center.y);
            g.scale(radius, radius);
            g.setColor(color);
            g.draw(this.circle);
            g.setTransform(old);
        }
        this.restoreState(g);
    }

    public void drawSolidPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        Color f = this.cpool.getColor(color.x, color.y, color.z, 0.4f);
        Color s = this.cpool.getColor(color.x, color.y, color.z, 1.0);
        Graphics2D g = this.getGraphics();
        this.saveState(g);
        int[] xInts = xIntsPool.get(vertexCount);
        int[] yInts = yIntsPool.get(vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            this.getWorldToScreenToOut(vertices[i], this.temp);
            xInts[i] = (int)this.temp.x;
            yInts[i] = (int)this.temp.y;
        }
        g.setStroke(this.stroke);
        g.setColor(f);
        g.fillPolygon(xInts, yInts, vertexCount);
        g.setColor(s);
        g.drawPolygon(xInts, yInts, vertexCount);
        this.restoreState(g);
    }

    public void drawPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        Color s = this.cpool.getColor(color.x, color.y, color.z, 1.0);
        Graphics2D g = this.getGraphics();
        this.saveState(g);
        int[] xInts = xIntsPool.get(vertexCount);
        int[] yInts = yIntsPool.get(vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            this.getWorldToScreenToOut(vertices[i], this.temp);
            xInts[i] = (int)this.temp.x;
            yInts[i] = (int)this.temp.y;
        }
        g.setStroke(this.stroke);
        g.setColor(s);
        g.drawPolygon(xInts, yInts, vertexCount);
        this.restoreState(g);
    }

    public void drawString(double x, double y, String s, Color3f color) {
        Graphics2D g = this.getGraphics();
        if (g == null) {
            return;
        }
        Color c = this.cpool.getColor(color.x, color.y, color.z);
        g.setColor(c);
        g.drawString(s, (float)x, (float)y);
    }

    private Graphics2D getGraphics() {
        return this.panel.getDBGraphics();
    }

    public void drawTransform(Transform xf) {
        Graphics2D g = this.getGraphics();
        this.getWorldToScreenToOut(xf.p, this.temp);
        this.temp2.setZero();
        double k_axisScale = 0.4f;
        Color c = this.cpool.getColor(1.0, 0.0, 0.0);
        g.setColor(c);
        this.temp2.x = xf.p.x + k_axisScale * xf.q.c;
        this.temp2.y = xf.p.y + k_axisScale * xf.q.s;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        g.drawLine((int)this.temp.x, (int)this.temp.y, (int)this.temp2.x, (int)this.temp2.y);
        c = this.cpool.getColor(0.0, 1.0, 0.0);
        g.setColor(c);
        this.temp2.x = xf.p.x + -k_axisScale * xf.q.s;
        this.temp2.y = xf.p.y + k_axisScale * xf.q.c;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        g.drawLine((int)this.temp.x, (int)this.temp.y, (int)this.temp2.x, (int)this.temp2.y);
    }
}

