/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.AbstractTestbedController;
import org.jbox2d.testbed.framework.TestbedCamera;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedTest;

public class AWTPanelHelper {
    static boolean screenDragButtonDown = false;
    static boolean mouseJointButtonDown = false;

    public static void addHelpAndPanelListeners(Component panel, final TestbedModel model, final AbstractTestbedController controller, final int screenDragButton) {
        final Vec2 oldDragMouse = new Vec2();
        final Vec2 mouse = new Vec2();
        ArrayList help = Lists.newArrayList();
        help.add("Click and drag the left mouse button to move objects.");
        help.add("Click and drag the right mouse button to move the view.");
        help.add("Shift-Click to aim a bullet, or press space.");
        help.add("Scroll to zoom in/out on the mouse position");
        help.add("Press '[' or ']' to change tests, and 'r' to restart.");
        model.setImplSpecificHelp(help);
        panel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                TestbedTest currTest = model.getCurrTest();
                if (currTest == null) {
                    return;
                }
                TestbedCamera.ZoomType zoom = notches < 0 ? TestbedCamera.ZoomType.ZOOM_IN : TestbedCamera.ZoomType.ZOOM_OUT;
                currTest.getCamera().zoomToPoint(mouse, zoom);
            }
        });
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.getButton() == screenDragButton) {
                    screenDragButtonDown = false;
                } else if (model.getCodedKeys()[16] && !mouseJointButtonDown) {
                    controller.queueMouseUp(new Vec2((double)arg0.getX(), (double)arg0.getY()), 10);
                } else {
                    if (arg0.getButton() == 1) {
                        mouseJointButtonDown = false;
                    }
                    controller.queueMouseUp(new Vec2((double)arg0.getX(), (double)arg0.getY()), arg0.getButton());
                }
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (arg0.getButton() == screenDragButton) {
                    screenDragButtonDown = true;
                    oldDragMouse.set((double)arg0.getX(), (double)arg0.getY());
                    return;
                }
                if (model.getCodedKeys()[16]) {
                    controller.queueMouseDown(new Vec2((double)arg0.getX(), (double)arg0.getY()), 10);
                } else {
                    if (arg0.getButton() == 1) {
                        mouseJointButtonDown = true;
                    }
                    controller.queueMouseDown(new Vec2((double)arg0.getX(), (double)arg0.getY()), arg0.getButton());
                }
            }
        });
        panel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
                mouse.set((double)arg0.getX(), (double)arg0.getY());
                controller.queueMouseMove(new Vec2(mouse));
            }

            @Override
            public void mouseDragged(MouseEvent arg0) {
                mouse.set((double)arg0.getX(), (double)arg0.getY());
                if (screenDragButtonDown) {
                    TestbedTest currTest = model.getCurrTest();
                    if (currTest == null) {
                        return;
                    }
                    Vec2 diff = oldDragMouse.sub(mouse);
                    currTest.getCamera().moveWorld(diff);
                    oldDragMouse.set(mouse);
                } else if (mouseJointButtonDown) {
                    controller.queueMouseDrag(new Vec2(mouse), 1);
                } else if (model.getCodedKeys()[16]) {
                    controller.queueMouseDrag(new Vec2((double)arg0.getX(), (double)arg0.getY()), 10);
                } else {
                    controller.queueMouseDrag(new Vec2(mouse), arg0.getButton());
                }
            }
        });
        panel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                controller.queueKeyReleased(arg0.getKeyChar(), arg0.getKeyCode());
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                char c = arg0.getKeyChar();
                controller.queueKeyPressed(c, arg0.getKeyCode());
                switch (c) {
                    case '[': {
                        controller.lastTest();
                        break;
                    }
                    case ']': {
                        controller.nextTest();
                        break;
                    }
                    case 'r': {
                        controller.reset();
                        break;
                    }
                    case ' ': {
                        controller.queueLaunchBomb();
                        break;
                    }
                    case 'p': {
                        controller.queuePause();
                    }
                }
            }
        });
    }
}

