/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.callbacks.ParticleDestructionListener;
import org.jbox2d.callbacks.ParticleQueryCallback;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Collision;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.Profile;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.particle.ParticleGroup;
import org.jbox2d.serialization.JbDeserializer;
import org.jbox2d.serialization.JbSerializer;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;
import org.jbox2d.serialization.pb.PbDeserializer;
import org.jbox2d.serialization.pb.PbSerializer;
import org.jbox2d.testbed.framework.ContactPoint;
import org.jbox2d.testbed.framework.ListenerAdapter;
import org.jbox2d.testbed.framework.ParticleVelocityQueryCallback;
import org.jbox2d.testbed.framework.SignerAdapter;
import org.jbox2d.testbed.framework.TestQueryCallback;
import org.jbox2d.testbed.framework.TestbedCamera;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedSettings;

public abstract class TestbedTest
implements ContactListener,
JbDeserializer.ObjectListener,
JbSerializer.ObjectSigner,
UnsupportedListener {
    public static final int MAX_CONTACT_POINTS = 4048;
    public static final double ZOOM_SCALE_DIFF = (double)0.05f;
    public static final int TEXT_LINE_SPACE = 13;
    public static final int TEXT_SECTION_SPACE = 3;
    public static final int MOUSE_JOINT_BUTTON = 1;
    public static final int BOMB_SPAWN_BUTTON = 10;
    protected static final long GROUND_BODY_TAG = 1897450239847L;
    protected static final long BOMB_TAG = 98989788987L;
    protected static final long MOUSE_JOINT_TAG = 4567893364789L;
    public final ContactPoint[] points = new ContactPoint[4048];
    protected World m_world;
    protected Body groundBody;
    private MouseJoint mouseJoint;
    private Body bomb;
    private final Vec2 bombMousePoint = new Vec2();
    private final Vec2 bombSpawnPoint = new Vec2();
    private boolean bombSpawning = false;
    protected boolean mouseTracing;
    private Vec2 mouseTracerPosition = new Vec2();
    private Vec2 mouseTracerVelocity = new Vec2();
    private final Vec2 mouseWorld = new Vec2();
    private int pointCount;
    private int stepCount;
    private TestbedModel model;
    protected DestructionListener destructionListener;
    protected ParticleDestructionListener particleDestructionListener;
    private String title = null;
    protected int m_textLine;
    private final LinkedList<String> textList = new LinkedList();
    private TestbedCamera camera;
    private JbSerializer serializer;
    private JbDeserializer deserializer;
    private final Transform identity = new Transform();
    private final Color3f color1 = new Color3f((double)0.3f, (double)0.95f, (double)0.3f);
    private final Color3f color2 = new Color3f((double)0.3f, (double)0.3f, (double)0.95f);
    private final Color3f color3 = new Color3f((double)0.9f, (double)0.9f, (double)0.9f);
    private final Color3f color4 = new Color3f((double)0.6f, (double)0.61f, 1.0);
    private final Color3f color5 = new Color3f((double)0.9f, (double)0.9f, (double)0.3f);
    private final Color3f mouseColor = new Color3f(0.0, 1.0, 0.0);
    private final Vec2 p1 = new Vec2();
    private final Vec2 p2 = new Vec2();
    private final Vec2 tangent = new Vec2();
    private final List<String> statsList = new ArrayList<String>();
    private final Vec2 acceleration = new Vec2();
    private final CircleShape pshape = new CircleShape();
    private final ParticleVelocityQueryCallback pcallback = new ParticleVelocityQueryCallback();
    private final AABB paabb = new AABB();
    private final AABB queryAABB = new AABB();
    private final TestQueryCallback callback = new TestQueryCallback();
    private final Vec2 p = new Vec2();
    private final Vec2 v = new Vec2();
    private final AABB aabb = new AABB();
    private final Vec2 vel = new Vec2();
    private final Collision.PointState[] state1 = new Collision.PointState[Settings.maxManifoldPoints];
    private final Collision.PointState[] state2 = new Collision.PointState[Settings.maxManifoldPoints];
    private final WorldManifold worldManifold = new WorldManifold();

    public TestbedTest() {
        this.identity.setIdentity();
        for (int i = 0; i < 4048; ++i) {
            this.points[i] = new ContactPoint();
        }
        this.serializer = new PbSerializer((UnsupportedListener)this, (JbSerializer.ObjectSigner)new SignerAdapter(this){

            @Override
            public Long getTag(Body argBody) {
                if (TestbedTest.this.isSaveLoadEnabled()) {
                    if (argBody == TestbedTest.this.groundBody) {
                        return 1897450239847L;
                    }
                    if (argBody == TestbedTest.this.bomb) {
                        return 98989788987L;
                    }
                }
                return super.getTag(argBody);
            }

            @Override
            public Long getTag(Joint argJoint) {
                if (TestbedTest.this.isSaveLoadEnabled() && argJoint == TestbedTest.this.mouseJoint) {
                    return 4567893364789L;
                }
                return super.getTag(argJoint);
            }
        });
        this.deserializer = new PbDeserializer((UnsupportedListener)this, (JbDeserializer.ObjectListener)new ListenerAdapter(this){

            @Override
            public void processBody(Body argBody, Long argTag) {
                if (TestbedTest.this.isSaveLoadEnabled()) {
                    if (argTag == 1897450239847L) {
                        TestbedTest.this.groundBody = argBody;
                        return;
                    }
                    if (argTag == 98989788987L) {
                        TestbedTest.this.bomb = argBody;
                        return;
                    }
                }
                super.processBody(argBody, argTag);
            }

            @Override
            public void processJoint(Joint argJoint, Long argTag) {
                if (TestbedTest.this.isSaveLoadEnabled() && argTag == 4567893364789L) {
                    TestbedTest.this.mouseJoint = (MouseJoint)argJoint;
                    return;
                }
                super.processJoint(argJoint, argTag);
            }
        });
        this.destructionListener = new DestructionListener(){

            public void sayGoodbye(Fixture fixture) {
                TestbedTest.this.fixtureDestroyed(fixture);
            }

            public void sayGoodbye(Joint joint) {
                if (TestbedTest.this.mouseJoint == joint) {
                    TestbedTest.this.mouseJoint = null;
                } else {
                    TestbedTest.this.jointDestroyed(joint);
                }
            }
        };
        this.particleDestructionListener = new ParticleDestructionListener(){

            public void sayGoodbye(int index) {
                TestbedTest.this.particleDestroyed(index);
            }

            public void sayGoodbye(ParticleGroup group) {
                TestbedTest.this.particleGroupDestroyed(group);
            }
        };
        this.camera = new TestbedCamera(this.getDefaultCameraPos(), this.getDefaultCameraScale(), 0.05f);
    }

    public void init(TestbedModel model) {
        this.model = model;
        Vec2 gravity = new Vec2(0.0, -10.0);
        this.m_world = model.getWorldCreator().createWorld(gravity);
        this.m_world.setParticleGravityScale((double)0.4f);
        this.m_world.setParticleDensity((double)1.2f);
        this.bomb = null;
        this.mouseJoint = null;
        this.mouseTracing = false;
        this.mouseTracerPosition.setZero();
        this.mouseTracerVelocity.setZero();
        BodyDef bodyDef = new BodyDef();
        this.groundBody = this.m_world.createBody(bodyDef);
        this.init(this.m_world, false);
    }

    public void init(World world, boolean deserialized) {
        this.m_world = world;
        this.pointCount = 0;
        this.stepCount = 0;
        this.bombSpawning = false;
        this.model.getDebugDraw().setViewportTransform(this.camera.getTransform());
        world.setDestructionListener(this.destructionListener);
        world.setParticleDestructionListener(this.particleDestructionListener);
        world.setContactListener((ContactListener)this);
        world.setDebugDraw(this.model.getDebugDraw());
        this.title = this.getTestName();
        this.initTest(deserialized);
    }

    protected JbSerializer getSerializer() {
        return this.serializer;
    }

    protected JbDeserializer getDeserializer() {
        return this.deserializer;
    }

    public World getWorld() {
        return this.m_world;
    }

    public TestbedModel getModel() {
        return this.model;
    }

    public ContactPoint[] getContactPoints() {
        return this.points;
    }

    public Body getGroundBody() {
        return this.groundBody;
    }

    public DebugDraw getDebugDraw() {
        return this.model.getDebugDraw();
    }

    public Vec2 getWorldMouse() {
        return this.mouseWorld;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public TestbedCamera getCamera() {
        return this.camera;
    }

    public Body getBomb() {
        return this.bomb;
    }

    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0, 20.0);
    }

    public double getDefaultCameraScale() {
        return 10.0;
    }

    public boolean isMouseTracing() {
        return this.mouseTracing;
    }

    public Vec2 getMouseTracerPosition() {
        return this.mouseTracerPosition;
    }

    public Vec2 getMouseTracerVelocity() {
        return this.mouseTracerVelocity;
    }

    public String getFilename() {
        return this.getTestName().toLowerCase().replaceAll(" ", "_") + ".box2d";
    }

    public void setCamera(Vec2 argPos) {
        this.camera.setCamera(argPos);
    }

    public void setCamera(Vec2 argPos, double scale) {
        this.camera.setCamera(argPos, scale);
    }

    public abstract void initTest(boolean var1);

    public abstract String getTestName();

    public void addTextLine(String line) {
        this.textList.add(line);
    }

    public void exit() {
    }

    public void step(TestbedSettings settings) {
        double timeStep;
        double hz = settings.getSetting((String)"Hz").value;
        double d = timeStep = hz > 0.0 ? 1.0 / hz : 0.0;
        if (settings.singleStep && !settings.pause) {
            settings.pause = true;
        }
        DebugDraw debugDraw = this.model.getDebugDraw();
        this.m_textLine = 20;
        if (this.title != null) {
            debugDraw.drawString(this.camera.getTransform().getExtents().x, 15.0, this.title, Color3f.WHITE);
            this.m_textLine += 13;
        }
        if (settings.pause) {
            if (settings.singleStep) {
                settings.singleStep = false;
            } else {
                timeStep = 0.0;
            }
            debugDraw.drawString(5.0, (double)this.m_textLine, "****PAUSED****", Color3f.WHITE);
            this.m_textLine += 13;
        }
        int flags = 0;
        flags += settings.getSetting((String)"Shapes").enabled ? 2 : 0;
        flags += settings.getSetting((String)"Joints").enabled ? 4 : 0;
        flags += settings.getSetting((String)"AABBs").enabled ? 8 : 0;
        flags += settings.getSetting((String)"Center of Mass").enabled ? 32 : 0;
        flags += settings.getSetting((String)"Dynamic Tree").enabled ? 64 : 0;
        debugDraw.setFlags(flags += settings.getSetting((String)"Wireframe Mode").enabled ? 128 : 0);
        this.m_world.setAllowSleep(settings.getSetting((String)"Sleep").enabled);
        this.m_world.setWarmStarting(settings.getSetting((String)"Warm Starting").enabled);
        this.m_world.setSubStepping(settings.getSetting((String)"SubStepping").enabled);
        this.m_world.setContinuousPhysics(settings.getSetting((String)"Continuous Collision").enabled);
        this.pointCount = 0;
        this.m_world.step(timeStep, settings.getSetting((String)"Vel Iters").value, settings.getSetting((String)"Pos Iters").value);
        this.m_world.drawDebugData();
        if (timeStep > 0.0) {
            ++this.stepCount;
        }
        debugDraw.drawString(5.0, (double)this.m_textLine, "Engine Info", this.color4);
        this.m_textLine += 13;
        debugDraw.drawString(5.0, (double)this.m_textLine, "Framerate: " + (int)this.model.getCalculatedFps(), Color3f.WHITE);
        this.m_textLine += 13;
        if (settings.getSetting((String)"Stats").enabled) {
            int particleCount = this.m_world.getParticleCount();
            int groupCount = this.m_world.getParticleGroupCount();
            debugDraw.drawString(5.0, (double)this.m_textLine, "bodies/contacts/joints/proxies/particles/groups = " + this.m_world.getBodyCount() + "/" + this.m_world.getContactCount() + "/" + this.m_world.getJointCount() + "/" + this.m_world.getProxyCount() + "/" + particleCount + "/" + groupCount, Color3f.WHITE);
            this.m_textLine += 13;
            debugDraw.drawString(5.0, (double)this.m_textLine, "World mouse position: " + this.mouseWorld.toString(), Color3f.WHITE);
            this.m_textLine += 13;
            this.statsList.clear();
            Profile p = this.getWorld().getProfile();
            p.toDebugStrings(this.statsList);
            for (String s : this.statsList) {
                debugDraw.drawString(5.0, (double)this.m_textLine, s, Color3f.WHITE);
                this.m_textLine += 13;
            }
            this.m_textLine += 3;
        }
        if (settings.getSetting((String)"Help").enabled) {
            debugDraw.drawString(5.0, (double)this.m_textLine, "Help", this.color4);
            this.m_textLine += 13;
            List<String> help = this.model.getImplSpecificHelp();
            for (String string : help) {
                debugDraw.drawString(5.0, (double)this.m_textLine, string, Color3f.WHITE);
                this.m_textLine += 13;
            }
            this.m_textLine += 3;
        }
        if (!this.textList.isEmpty()) {
            debugDraw.drawString(5.0, (double)this.m_textLine, "Test Info", this.color4);
            this.m_textLine += 13;
            for (String s : this.textList) {
                debugDraw.drawString(5.0, (double)this.m_textLine, s, Color3f.WHITE);
                this.m_textLine += 13;
            }
            this.textList.clear();
        }
        if (this.mouseTracing && this.mouseJoint == null) {
            double delay = 0.1f;
            this.acceleration.x = 2.0 / delay * (1.0 / delay * (this.mouseWorld.x - this.mouseTracerPosition.x) - this.mouseTracerVelocity.x);
            this.acceleration.y = 2.0 / delay * (1.0 / delay * (this.mouseWorld.y - this.mouseTracerPosition.y) - this.mouseTracerVelocity.y);
            this.mouseTracerVelocity.x += timeStep * this.acceleration.x;
            this.mouseTracerVelocity.y += timeStep * this.acceleration.y;
            this.mouseTracerPosition.x += timeStep * this.mouseTracerVelocity.x;
            this.mouseTracerPosition.y += timeStep * this.mouseTracerVelocity.y;
            this.pshape.m_p.set(this.mouseTracerPosition);
            this.pshape.m_radius = 2.0;
            this.pcallback.init(this.m_world, (Shape)this.pshape, this.mouseTracerVelocity);
            this.pshape.computeAABB(this.paabb, this.identity, 0);
            this.m_world.queryAABB((ParticleQueryCallback)this.pcallback, this.paabb);
        }
        if (this.mouseJoint != null) {
            this.mouseJoint.getAnchorB(this.p1);
            Vec2 p2 = this.mouseJoint.getTarget();
            debugDraw.drawSegment(this.p1, p2, this.mouseColor);
        }
        if (this.bombSpawning) {
            debugDraw.drawSegment(this.bombSpawnPoint, this.bombMousePoint, Color3f.WHITE);
        }
        if (settings.getSetting((String)"Contact Points").enabled) {
            double k_impulseScale = 0.1f;
            double axisScale = 0.3f;
            for (int i = 0; i < this.pointCount; ++i) {
                ContactPoint point = this.points[i];
                if (point.state == Collision.PointState.ADD_STATE) {
                    debugDraw.drawPoint(point.position, 10.0, this.color1);
                } else if (point.state == Collision.PointState.PERSIST_STATE) {
                    debugDraw.drawPoint(point.position, 5.0, this.color2);
                }
                if (settings.getSetting((String)"Contact Normals").enabled) {
                    this.p1.set(point.position);
                    this.p2.set(point.normal).mulLocal((double)0.3f).addLocal(this.p1);
                    debugDraw.drawSegment(this.p1, this.p2, this.color3);
                } else if (settings.getSetting((String)"Contact Impulses").enabled) {
                    this.p1.set(point.position);
                    this.p2.set(point.normal).mulLocal((double)0.1f).mulLocal(point.normalImpulse).addLocal(this.p1);
                    debugDraw.drawSegment(this.p1, this.p2, this.color5);
                }
                if (!settings.getSetting((String)"Friction Impulses").enabled) continue;
                Vec2.crossToOutUnsafe((Vec2)point.normal, (double)1.0, (Vec2)this.tangent);
                this.p1.set(point.position);
                this.p2.set(this.tangent).mulLocal((double)0.1f).mulLocal(point.tangentImpulse).addLocal(this.p1);
                debugDraw.drawSegment(this.p1, this.p2, this.color5);
            }
        }
    }

    public void mouseUp(Vec2 p, int button) {
        this.mouseTracing = false;
        if (button == 1) {
            this.destroyMouseJoint();
        }
        this.completeBombSpawn(p);
    }

    public void keyPressed(char keyChar, int keyCode) {
    }

    public void keyReleased(char keyChar, int keyCode) {
    }

    public void mouseDown(Vec2 p, int button) {
        this.mouseWorld.set(p);
        this.mouseTracing = true;
        this.mouseTracerVelocity.setZero();
        this.mouseTracerPosition.set(p);
        if (button == 10) {
            this.beginBombSpawn(p);
        }
        if (button == 1) {
            this.spawnMouseJoint(p);
        }
    }

    public void mouseMove(Vec2 p) {
        this.mouseWorld.set(p);
    }

    public void mouseDrag(Vec2 p, int button) {
        this.mouseWorld.set(p);
        if (button == 1) {
            this.updateMouseJoint(p);
        }
        if (button == 10) {
            this.bombMousePoint.set(p);
        }
    }

    private void spawnMouseJoint(Vec2 p) {
        if (this.mouseJoint != null) {
            return;
        }
        this.queryAABB.lowerBound.set(p.x - (double)0.001f, p.y - (double)0.001f);
        this.queryAABB.upperBound.set(p.x + (double)0.001f, p.y + (double)0.001f);
        this.callback.point.set(p);
        this.callback.fixture = null;
        this.m_world.queryAABB((QueryCallback)this.callback, this.queryAABB);
        if (this.callback.fixture != null) {
            Body body = this.callback.fixture.getBody();
            MouseJointDef def = new MouseJointDef();
            def.bodyA = this.groundBody;
            def.bodyB = body;
            def.collideConnected = true;
            def.target.set(p);
            def.maxForce = 1000.0 * body.getMass();
            this.mouseJoint = (MouseJoint)this.m_world.createJoint((JointDef)def);
            body.setAwake(true);
        }
    }

    private void updateMouseJoint(Vec2 target) {
        if (this.mouseJoint != null) {
            this.mouseJoint.setTarget(target);
        }
    }

    private void destroyMouseJoint() {
        if (this.mouseJoint != null) {
            this.m_world.destroyJoint((Joint)this.mouseJoint);
            this.mouseJoint = null;
        }
    }

    public void lanchBomb() {
        this.p.set(Math.random() * 30.0 - 15.0, 30.0);
        this.v.set(this.p).mulLocal(-5.0);
        this.launchBomb(this.p, this.v);
    }

    private void launchBomb(Vec2 position, Vec2 velocity) {
        if (this.bomb != null) {
            this.m_world.destroyBody(this.bomb);
            this.bomb = null;
        }
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(position);
        bd.bullet = true;
        this.bomb = this.m_world.createBody(bd);
        this.bomb.setLinearVelocity(velocity);
        CircleShape circle = new CircleShape();
        circle.m_radius = 0.3f;
        FixtureDef fd = new FixtureDef();
        fd.shape = circle;
        fd.density = 20.0;
        fd.restitution = 0.0;
        Vec2 minV = new Vec2(position);
        Vec2 maxV = new Vec2(position);
        minV.subLocal(new Vec2((double)0.3f, (double)0.3f));
        maxV.addLocal(new Vec2((double)0.3f, (double)0.3f));
        this.aabb.lowerBound.set(minV);
        this.aabb.upperBound.set(maxV);
        this.bomb.createFixture(fd);
    }

    private void beginBombSpawn(Vec2 worldPt) {
        this.bombSpawnPoint.set(worldPt);
        this.bombMousePoint.set(worldPt);
        this.bombSpawning = true;
    }

    private void completeBombSpawn(Vec2 p) {
        if (!this.bombSpawning) {
            return;
        }
        double multiplier = 30.0;
        this.vel.set(this.bombSpawnPoint).subLocal(p);
        this.vel.mulLocal(multiplier);
        this.launchBomb(this.bombSpawnPoint, this.vel);
        this.bombSpawning = false;
    }

    public boolean isSaveLoadEnabled() {
        return false;
    }

    public Long getTag(Body body) {
        return null;
    }

    public Long getTag(Fixture fixture) {
        return null;
    }

    public Long getTag(Joint joint) {
        return null;
    }

    public Long getTag(Shape shape) {
        return null;
    }

    public Long getTag(World world) {
        return null;
    }

    public void processBody(Body body, Long tag) {
    }

    public void processFixture(Fixture fixture, Long tag) {
    }

    public void processJoint(Joint joint, Long tag) {
    }

    public void processShape(Shape shape, Long tag) {
    }

    public void processWorld(World world, Long tag) {
    }

    public boolean isUnsupported(UnsupportedObjectException exception) {
        return true;
    }

    public void fixtureDestroyed(Fixture fixture) {
    }

    public void jointDestroyed(Joint joint) {
    }

    public void beginContact(Contact contact) {
    }

    public void endContact(Contact contact) {
    }

    public void particleDestroyed(int particle) {
    }

    public void particleGroupDestroyed(ParticleGroup group) {
    }

    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    public void preSolve(Contact contact, Manifold oldManifold) {
        Manifold manifold = contact.getManifold();
        if (manifold.pointCount == 0) {
            return;
        }
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        Collision.getPointStates((Collision.PointState[])this.state1, (Collision.PointState[])this.state2, (Manifold)oldManifold, (Manifold)manifold);
        contact.getWorldManifold(this.worldManifold);
        for (int i = 0; i < manifold.pointCount && this.pointCount < 4048; ++i) {
            ContactPoint cp = this.points[this.pointCount];
            cp.fixtureA = fixtureA;
            cp.fixtureB = fixtureB;
            cp.position.set(this.worldManifold.points[i]);
            cp.normal.set(this.worldManifold.normal);
            cp.state = this.state2[i];
            cp.normalImpulse = manifold.points[i].normalImpulse;
            cp.tangentImpulse = manifold.points[i].tangentImpulse;
            cp.separation = this.worldManifold.separations[i];
            ++this.pointCount;
        }
    }
}

