/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbox2d.testbed.framework.TestbedSetting;

public class TestbedSettings {
    public static final String Hz = "Hz";
    public static final String PositionIterations = "Pos Iters";
    public static final String VelocityIterations = "Vel Iters";
    public static final String AllowSleep = "Sleep";
    public static final String WarmStarting = "Warm Starting";
    public static final String SubStepping = "SubStepping";
    public static final String ContinuousCollision = "Continuous Collision";
    public static final String DrawShapes = "Shapes";
    public static final String DrawJoints = "Joints";
    public static final String DrawAABBs = "AABBs";
    public static final String DrawContactPoints = "Contact Points";
    public static final String DrawContactNormals = "Contact Normals";
    public static final String DrawContactImpulses = "Contact Impulses";
    public static final String DrawFrictionImpulses = "Friction Impulses";
    public static final String DrawCOMs = "Center of Mass";
    public static final String DrawStats = "Stats";
    public static final String DrawHelp = "Help";
    public static final String DrawTree = "Dynamic Tree";
    public static final String DrawWireframe = "Wireframe Mode";
    public boolean pause = false;
    public boolean singleStep = false;
    private List<TestbedSetting> settings = Lists.newArrayList();
    private final Map<String, TestbedSetting> settingsMap = Maps.newHashMap();

    public TestbedSettings() {
        this.populateDefaultSettings();
    }

    private void populateDefaultSettings() {
        this.addSetting(new TestbedSetting(Hz, TestbedSetting.SettingType.ENGINE, 60, 1, 400));
        this.addSetting(new TestbedSetting(PositionIterations, TestbedSetting.SettingType.ENGINE, 3, 0, 100));
        this.addSetting(new TestbedSetting(VelocityIterations, TestbedSetting.SettingType.ENGINE, 8, 1, 100));
        this.addSetting(new TestbedSetting(AllowSleep, TestbedSetting.SettingType.ENGINE, true));
        this.addSetting(new TestbedSetting(WarmStarting, TestbedSetting.SettingType.ENGINE, true));
        this.addSetting(new TestbedSetting(ContinuousCollision, TestbedSetting.SettingType.ENGINE, true));
        this.addSetting(new TestbedSetting(SubStepping, TestbedSetting.SettingType.ENGINE, false));
        this.addSetting(new TestbedSetting(DrawShapes, TestbedSetting.SettingType.DRAWING, true));
        this.addSetting(new TestbedSetting(DrawJoints, TestbedSetting.SettingType.DRAWING, true));
        this.addSetting(new TestbedSetting(DrawAABBs, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawContactPoints, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawContactNormals, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawContactImpulses, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawFrictionImpulses, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawCOMs, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawStats, TestbedSetting.SettingType.DRAWING, true));
        this.addSetting(new TestbedSetting(DrawHelp, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawTree, TestbedSetting.SettingType.DRAWING, false));
        this.addSetting(new TestbedSetting(DrawWireframe, TestbedSetting.SettingType.DRAWING, true));
    }

    public void addSetting(TestbedSetting argSetting) {
        if (this.settingsMap.containsKey(argSetting.name)) {
            throw new IllegalArgumentException("Settings already contain a setting with name: " + argSetting.name);
        }
        this.settings.add(argSetting);
        this.settingsMap.put(argSetting.name, argSetting);
    }

    public List<TestbedSetting> getSettings() {
        return Collections.unmodifiableList(this.settings);
    }

    public TestbedSetting getSetting(String argName) {
        return this.settingsMap.get(argName);
    }
}

