/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.testbed.framework.DefaultWorldCreator;
import org.jbox2d.testbed.framework.TestbedPanel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.framework.WorldCreator;

public class TestbedModel {
    private final DefaultComboBoxModel tests = new DefaultComboBoxModel();
    private final TestbedSettings settings = new TestbedSettings();
    private DebugDraw draw;
    private TestbedTest test;
    private final Vector<TestChangedListener> listeners = new Vector();
    private final boolean[] keys = new boolean[512];
    private final boolean[] codedKeys = new boolean[512];
    private double calculatedFps;
    private int currTestIndex = -1;
    private TestbedTest runningTest;
    private List<String> implSpecificHelp;
    private TestbedPanel panel;
    private WorldCreator worldCreator = new DefaultWorldCreator();

    public WorldCreator getWorldCreator() {
        return this.worldCreator;
    }

    public void setWorldCreator(WorldCreator worldCreator) {
        this.worldCreator = worldCreator;
    }

    public void setPanel(TestbedPanel panel) {
        this.panel = panel;
    }

    public TestbedPanel getPanel() {
        return this.panel;
    }

    public void setImplSpecificHelp(List<String> implSpecificHelp) {
        this.implSpecificHelp = implSpecificHelp;
    }

    public List<String> getImplSpecificHelp() {
        return this.implSpecificHelp;
    }

    public void setCalculatedFps(double calculatedFps) {
        this.calculatedFps = calculatedFps;
    }

    public double getCalculatedFps() {
        return this.calculatedFps;
    }

    public void setViewportTransform(IViewportTransform transform) {
        this.draw.setViewportTransform(transform);
    }

    public void setDebugDraw(DebugDraw argDraw) {
        this.draw = argDraw;
    }

    public DebugDraw getDebugDraw() {
        return this.draw;
    }

    public TestbedTest getCurrTest() {
        return this.test;
    }

    public boolean[] getKeys() {
        return this.keys;
    }

    public boolean[] getCodedKeys() {
        return this.codedKeys;
    }

    public void setCurrTestIndex(int argCurrTestIndex) {
        if (argCurrTestIndex < 0 || argCurrTestIndex >= this.tests.getSize()) {
            throw new IllegalArgumentException("Invalid test index");
        }
        if (this.currTestIndex == argCurrTestIndex) {
            return;
        }
        if (!this.isTestAt(argCurrTestIndex)) {
            throw new IllegalArgumentException("No test at " + argCurrTestIndex);
        }
        this.currTestIndex = argCurrTestIndex;
        ListItem item = (ListItem)this.tests.getElementAt(argCurrTestIndex);
        this.test = item.test;
        for (TestChangedListener listener : this.listeners) {
            listener.testChanged(this.test, this.currTestIndex);
        }
    }

    public int getCurrTestIndex() {
        return this.currTestIndex;
    }

    public void setRunningTest(TestbedTest runningTest) {
        this.runningTest = runningTest;
    }

    public TestbedTest getRunningTest() {
        return this.runningTest;
    }

    public void addTestChangeListener(TestChangedListener argListener) {
        this.listeners.add(argListener);
    }

    public void removeTestChangeListener(TestChangedListener argListener) {
        this.listeners.remove(argListener);
    }

    public void addTest(TestbedTest argTest) {
        this.tests.addElement(new ListItem(argTest));
    }

    public void addCategory(String argName) {
        this.tests.addElement(new ListItem(argName));
    }

    public TestbedTest getTestAt(int argIndex) {
        ListItem item = (ListItem)this.tests.getElementAt(argIndex);
        if (item.isCategory()) {
            return null;
        }
        return item.test;
    }

    public boolean isTestAt(int argIndex) {
        ListItem item = (ListItem)this.tests.getElementAt(argIndex);
        return !item.isCategory();
    }

    public void clearTestList() {
        this.tests.removeAllElements();
    }

    public int getTestsSize() {
        return this.tests.getSize();
    }

    public DefaultComboBoxModel getComboModel() {
        return this.tests;
    }

    public TestbedSettings getSettings() {
        return this.settings;
    }

    public static interface TestChangedListener {
        public void testChanged(TestbedTest var1, int var2);
    }

    public class ListItem {
        public String category;
        public TestbedTest test;

        public ListItem(String argCategory) {
            this.category = argCategory;
        }

        public ListItem(TestbedTest argTest) {
            this.test = argTest;
        }

        public boolean isCategory() {
            return this.category != null;
        }

        public String toString() {
            return this.isCategory() ? this.category : this.test.getTestName();
        }
    }
}

