/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import com.google.common.base.Preconditions;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Vec2;

public class TestbedCamera {
    private final Vec2 initPosition = new Vec2();
    private double initScale;
    private final IViewportTransform transform;
    private final Mat22 upScale;
    private final Mat22 downScale;
    private final Vec2 oldCenter = new Vec2();
    private final Vec2 newCenter = new Vec2();
    private final Vec2 worldDiff = new Vec2();

    public TestbedCamera(Vec2 initPosition, double initScale, double zoomScaleDiff) {
        Preconditions.checkArgument((zoomScaleDiff > 0.0 ? 1 : 0) != 0, (String)"Zoom scale %d must be > 0", (Object[])new Object[]{zoomScaleDiff});
        this.transform = new OBBViewportTransform();
        this.transform.setCamera(initPosition.x, initPosition.y, initScale);
        this.initPosition.set(initPosition);
        this.initScale = initScale;
        this.upScale = Mat22.createScaleTransform((double)(1.0 + zoomScaleDiff));
        this.downScale = Mat22.createScaleTransform((double)(1.0 - zoomScaleDiff));
    }

    public void reset() {
        this.setCamera(this.initPosition, this.initScale);
    }

    public void setCamera(Vec2 worldCenter) {
        this.transform.setCenter(worldCenter);
    }

    public void setCamera(Vec2 worldCenter, double scale) {
        this.transform.setCamera(worldCenter.x, worldCenter.y, scale);
    }

    public void zoomToPoint(Vec2 screenPosition, ZoomType zoomType) {
        Mat22 zoom;
        switch (zoomType) {
            case ZOOM_IN: {
                zoom = this.upScale;
                break;
            }
            case ZOOM_OUT: {
                zoom = this.downScale;
                break;
            }
            default: {
                Preconditions.checkArgument((boolean)false, (Object)"Zoom type invalid");
                return;
            }
        }
        this.transform.getScreenToWorld(screenPosition, this.oldCenter);
        this.transform.mulByTransform(zoom);
        this.transform.getScreenToWorld(screenPosition, this.newCenter);
        Vec2 transformedMove = this.oldCenter.subLocal(this.newCenter);
        if (!this.transform.isYFlip()) {
            transformedMove.y = -transformedMove.y;
        }
        this.transform.setCenter(this.transform.getCenter().addLocal(transformedMove));
    }

    public void moveWorld(Vec2 screenDiff) {
        this.transform.getScreenVectorToWorld(screenDiff, this.worldDiff);
        if (!this.transform.isYFlip()) {
            this.worldDiff.y = -this.worldDiff.y;
        }
        this.transform.setCenter(this.transform.getCenter().addLocal(this.worldDiff));
    }

    public IViewportTransform getTransform() {
        return this.transform;
    }

    public static enum ZoomType {
        ZOOM_IN,
        ZOOM_OUT;

    }
}

