/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.World;
import org.jbox2d.serialization.SerializationResult;
import org.jbox2d.serialization.UnsupportedObjectException;
import org.jbox2d.testbed.framework.QueueItem;
import org.jbox2d.testbed.framework.QueueItemType;
import org.jbox2d.testbed.framework.TestbedErrorHandler;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedPanel;
import org.jbox2d.testbed.framework.TestbedTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestbedController {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestbedController.class);
    public static final int DEFAULT_FPS = 60;
    private TestbedTest currTest = null;
    private TestbedTest nextTest = null;
    private long frameCount;
    private int targetFrameRate;
    private double frameRate = 0.0;
    private boolean animating = false;
    private final TestbedModel model;
    private boolean savePending;
    private boolean loadPending;
    private boolean resetPending = false;
    private final UpdateBehavior updateBehavior;
    private final MouseBehavior mouseBehavior;
    private final LinkedList<QueueItem> inputQueue;
    private final TestbedErrorHandler errorHandler;
    private double viewportHalfHeight;
    private double viewportHalfWidth;
    protected long startTime;
    protected long beforeTime;
    protected long afterTime;
    protected long updateTime;
    protected long timeDiff;
    protected long sleepTime;
    protected long timeSpent;

    public AbstractTestbedController(TestbedModel argModel, UpdateBehavior behavior, MouseBehavior mouseBehavior, TestbedErrorHandler errorHandler) {
        this.model = argModel;
        this.inputQueue = Lists.newLinkedList();
        this.setFrameRate(60);
        this.updateBehavior = behavior;
        this.errorHandler = errorHandler;
        this.mouseBehavior = mouseBehavior;
        this.addListeners();
    }

    private void addListeners() {
        this.model.addTestChangeListener(new TestbedModel.TestChangedListener(){

            @Override
            public void testChanged(TestbedTest test, int index) {
                AbstractTestbedController.this.model.getPanel().grabFocus();
                AbstractTestbedController.this.nextTest = test;
            }
        });
    }

    public void load() {
        this.loadPending = true;
    }

    public void save() {
        this.savePending = true;
    }

    public void reset() {
        this.resetPending = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueLaunchBomb() {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePause() {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.Pause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseUp(Vec2 screenPos, int button) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.MouseUp, screenPos, button));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseDown(Vec2 screenPos, int button) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.MouseDown, screenPos, button));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseMove(Vec2 screenPos) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.MouseMove, screenPos, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseDrag(Vec2 screenPos, int button) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.MouseDrag, screenPos, button));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueKeyPressed(char c, int code) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.KeyPressed, c, code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueKeyReleased(char c, int code) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.add(new QueueItem(QueueItemType.KeyReleased, c, code));
        }
    }

    public void updateExtents(double halfWidth, double halfHeight) {
        this.viewportHalfHeight = halfHeight;
        this.viewportHalfWidth = halfWidth;
        if (this.currTest != null) {
            this.currTest.getCamera().getTransform().setExtents(halfWidth, halfHeight);
        }
    }

    protected void loopInit() {
        this.model.getPanel().grabFocus();
        if (this.currTest != null) {
            this.currTest.init(this.model);
        }
    }

    private void initTest(TestbedTest test) {
        test.init(this.model);
        test.getCamera().getTransform().setExtents(this.viewportHalfWidth, this.viewportHalfHeight);
        this.model.getPanel().grabFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTest() {
        if (this.resetPending) {
            if (this.currTest != null) {
                this.currTest.init(this.model);
            }
            this.resetPending = false;
            this.model.getPanel().grabFocus();
        }
        if (this.savePending) {
            if (this.currTest != null) {
                this._save();
            }
            this.savePending = false;
            this.model.getPanel().grabFocus();
        }
        if (this.loadPending) {
            if (this.currTest != null) {
                this._load();
            }
            this.loadPending = false;
            this.model.getPanel().grabFocus();
        }
        if (this.currTest == null) {
            LinkedList<QueueItem> linkedList = this.inputQueue;
            synchronized (linkedList) {
                this.inputQueue.clear();
                return;
            }
        }
        IViewportTransform transform = this.currTest.getCamera().getTransform();
        while (!this.inputQueue.isEmpty()) {
            QueueItem i = null;
            LinkedList<QueueItem> linkedList = this.inputQueue;
            synchronized (linkedList) {
                if (!this.inputQueue.isEmpty()) {
                    i = this.inputQueue.pop();
                }
            }
            if (i == null) continue;
            boolean oldFlip = transform.isYFlip();
            if (this.mouseBehavior == MouseBehavior.FORCE_Y_FLIP) {
                transform.setYFlip(true);
            }
            this.currTest.getCamera().getTransform().getScreenToWorld(i.p, i.p);
            if (this.mouseBehavior == MouseBehavior.FORCE_Y_FLIP) {
                transform.setYFlip(oldFlip);
            }
            switch (i.type) {
                case KeyPressed: {
                    if (i.c != '\uffff') {
                        this.model.getKeys()[i.c] = true;
                    }
                    this.model.getCodedKeys()[i.code] = true;
                    this.currTest.keyPressed(i.c, i.code);
                    break;
                }
                case KeyReleased: {
                    if (i.c != '\uffff') {
                        this.model.getKeys()[i.c] = false;
                    }
                    this.model.getCodedKeys()[i.code] = false;
                    this.currTest.keyReleased(i.c, i.code);
                    break;
                }
                case MouseDown: {
                    this.currTest.mouseDown(i.p, i.button);
                    break;
                }
                case MouseMove: {
                    this.currTest.mouseMove(i.p);
                    break;
                }
                case MouseUp: {
                    this.currTest.mouseUp(i.p, i.button);
                    break;
                }
                case MouseDrag: {
                    this.currTest.mouseDrag(i.p, i.button);
                    break;
                }
                case LaunchBomb: {
                    this.currTest.lanchBomb();
                    break;
                }
                case Pause: {
                    this.model.getSettings().pause = !this.model.getSettings().pause;
                }
            }
        }
        if (this.currTest != null) {
            this.currTest.step(this.model.getSettings());
        }
    }

    public void nextTest() {
        int index = this.model.getCurrTestIndex() + 1;
        index %= this.model.getTestsSize();
        while (!this.model.isTestAt(index) && index < this.model.getTestsSize() - 1) {
            ++index;
        }
        if (this.model.isTestAt(index)) {
            this.model.setCurrTestIndex(index);
        }
    }

    public void lastTest() {
        int index = this.model.getCurrTestIndex() - 1;
        while (index >= 0 && !this.model.isTestAt(index)) {
            if (index == 0) {
                index = this.model.getTestsSize() - 1;
                continue;
            }
            --index;
        }
        if (this.model.isTestAt(index)) {
            this.model.setCurrTestIndex(index);
        }
    }

    public void playTest(int argIndex) {
        if (argIndex == -1) {
            return;
        }
        while (!this.model.isTestAt(argIndex)) {
            if (argIndex + 1 < this.model.getTestsSize()) {
                ++argIndex;
                continue;
            }
            return;
        }
        this.model.setCurrTestIndex(argIndex);
    }

    public void setFrameRate(int fps) {
        if (fps <= 0) {
            throw new IllegalArgumentException("Fps cannot be less than or equal to zero");
        }
        this.targetFrameRate = fps;
        this.frameRate = fps;
    }

    public int getFrameRate() {
        return this.targetFrameRate;
    }

    public double getCalculatedFrameRate() {
        return this.frameRate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public synchronized void start() {
        if (!this.isAnimating()) {
            this.startAnimator();
        } else {
            log.warn("Animation is already animating.");
        }
    }

    public synchronized void stop() {
        this.animating = false;
        this.stopAnimator();
    }

    public void startAnimator() {
        this.animating = true;
    }

    public void stopAnimator() {
        this.animating = false;
    }

    protected void stepAndRender() {
        if (this.nextTest != null) {
            this.initTest(this.nextTest);
            this.model.setRunningTest(this.nextTest);
            if (this.currTest != null) {
                this.currTest.exit();
            }
            this.currTest = this.nextTest;
            this.nextTest = null;
        }
        this.timeSpent = this.beforeTime - this.updateTime;
        if (this.timeSpent > 0L) {
            double timeInSecs = (float)this.timeSpent * 1.0f / 1.0E9f;
            this.updateTime = System.nanoTime();
            this.frameRate = this.frameRate * (double)0.9f + 1.0 / timeInSecs * (double)0.1f;
            this.model.setCalculatedFps(this.frameRate);
        } else {
            this.updateTime = System.nanoTime();
        }
        this.render(this.model.getPanel());
        ++this.frameCount;
        this.afterTime = System.nanoTime();
        this.timeDiff = this.afterTime - this.beforeTime;
        this.sleepTime = ((long)(1000000000 / this.targetFrameRate) - this.timeDiff) / 1000000L;
        this.beforeTime = System.nanoTime();
    }

    protected void render(TestbedPanel panel) {
        if (panel.render()) {
            if (this.currTest != null && this.updateBehavior == UpdateBehavior.UPDATE_CALLED) {
                this.updateTest();
            }
            panel.paintScreen();
        }
    }

    private void _save() {
        block7: {
            SerializationResult result;
            try {
                result = this.currTest.getSerializer().serialize(this.currTest.getWorld());
            }
            catch (UnsupportedObjectException e1) {
                log.error("Error serializing world", (Throwable)e1);
                if (this.errorHandler != null) {
                    this.errorHandler.serializationError((Exception)((Object)e1), "Error serializing the object: " + e1.toString());
                }
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(this.currTest.getFilename());
                result.writeTo((OutputStream)fos);
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException e) {
                log.error("File not found exception while saving", (Throwable)e);
                if (this.errorHandler != null) {
                    this.errorHandler.serializationError(e, "File not found exception while saving: " + this.currTest.getFilename());
                }
            }
            catch (IOException e) {
                log.error("Exception while writing world", (Throwable)e);
                if (this.errorHandler == null) break block7;
                this.errorHandler.serializationError(e, "Error while writing world: " + e.toString());
            }
        }
        log.debug("Serialed world to " + this.currTest.getFilename());
    }

    private void _load() {
        World w;
        try {
            FileInputStream fis = new FileInputStream(this.currTest.getFilename());
            w = this.currTest.getDeserializer().deserializeWorld((InputStream)fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.error("File not found error while loading", (Throwable)e);
            if (this.errorHandler != null) {
                this.errorHandler.serializationError(e, "File not found exception while loading: " + this.currTest.getFilename());
            }
            return;
        }
        catch (UnsupportedObjectException e) {
            log.error("Error deserializing object", (Throwable)e);
            if (this.errorHandler != null) {
                this.errorHandler.serializationError((Exception)((Object)e), "Error deserializing the object: " + e.toString());
            }
            return;
        }
        catch (IOException e) {
            log.error("Exception while reading world", (Throwable)e);
            if (this.errorHandler != null) {
                this.errorHandler.serializationError(e, "Error while reading world: " + e.toString());
            }
            return;
        }
        log.debug("Deserialized world from " + this.currTest.getFilename());
        this.currTest.init(w, true);
    }

    public static enum MouseBehavior {
        NORMAL,
        FORCE_Y_FLIP;

    }

    public static enum UpdateBehavior {
        UPDATE_CALLED,
        UPDATE_IGNORED;

    }
}

