/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.profile;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jbox2d.common.MathUtils;

public abstract class BasicPerformanceTest {
    private ResultFormat format = ResultFormat.MICROSECONDS;
    private final int numTests;
    private final int iters;
    private final int frames;
    protected final DescriptiveStatistics[] stats;
    private ArrayList<Integer> testOrder = new ArrayList();

    public BasicPerformanceTest(int numTests, int iters, int frames) {
        this.numTests = numTests;
        this.iters = iters;
        this.frames = frames;
        this.stats = new DescriptiveStatistics[numTests];
        for (int i = 0; i < numTests; ++i) {
            this.stats[i] = new DescriptiveStatistics(iters * frames + 1);
            this.testOrder.add(i);
        }
    }

    public void setFormat(ResultFormat format) {
        this.format = format;
    }

    public void go() {
        int runningTest;
        int test;
        int j;
        int test2;
        int i;
        this.println("Warmup");
        int warmupIters = this.iters / 10;
        for (i = 0; i < warmupIters; ++i) {
            this.println((double)i * 100.0 / (double)warmupIters + "%");
            Collections.shuffle(this.testOrder);
            for (test2 = 0; test2 < this.numTests; ++test2) {
                this.setupTest(test2);
            }
            for (j = 0; j < this.frames; ++j) {
                Collections.shuffle(this.testOrder);
                for (test = 0; test < this.numTests; ++test) {
                    runningTest = this.testOrder.get(test);
                    this.preStep(runningTest);
                    this.step(runningTest);
                }
            }
        }
        this.println("Testing");
        for (i = 0; i < this.iters; ++i) {
            this.println((double)i * 100.0 / (double)this.iters + "%");
            for (test2 = 0; test2 < this.numTests; ++test2) {
                this.setupTest(test2);
            }
            for (j = 0; j < this.frames; ++j) {
                Collections.shuffle(this.testOrder);
                for (test = 0; test < this.numTests; ++test) {
                    runningTest = this.testOrder.get(test);
                    this.preStep(runningTest);
                    long prev = System.nanoTime();
                    this.step(runningTest);
                    long after = System.nanoTime();
                    this.stats[runningTest].addValue((double)(after - prev));
                }
            }
        }
        this.printResults();
    }

    public void printResults() {
        this.printf("%-20s%20s%20s%20s\n", "Test Name", this.format.name + " Avg", "StdDev", "95% Interval");
        for (int i = 0; i < this.numTests; ++i) {
            double mean = this.stats[i].getMean() / (double)this.format.divisor;
            double stddev = this.stats[i].getStandardDeviation() / (double)this.format.divisor;
            double diff = 1.96 * stddev / MathUtils.sqrt((double)this.stats[i].getN());
            this.printf("%-20s%20.3f%20.3f  (%7.3f,%7.3f)\n", this.getTestName(i), mean, stddev, mean - diff, mean + diff);
        }
    }

    public void setupTest(int testNum) {
    }

    public void preStep(int testNum) {
    }

    public abstract void step(int var1);

    public abstract String getTestName(int var1);

    public int getFrames(int testNum) {
        return 0;
    }

    public void println(String s) {
        System.out.println(s);
    }

    public void printf(String s, Object ... args) {
        System.out.printf(s, args);
    }

    public static final class ResultFormat
    extends Enum<ResultFormat> {
        public static final /* enum */ ResultFormat MILLISECONDS = new ResultFormat(1000000, "Milliseconds");
        public static final /* enum */ ResultFormat MICROSECONDS = new ResultFormat(1000, "Microseconds");
        public static final /* enum */ ResultFormat NANOSECONDS = new ResultFormat(1, "Nanoseconds");
        private final int divisor;
        private final String name;
        private static final /* synthetic */ ResultFormat[] $VALUES;

        public static ResultFormat[] values() {
            return (ResultFormat[])$VALUES.clone();
        }

        public static ResultFormat valueOf(String name) {
            return Enum.valueOf(ResultFormat.class, name);
        }

        private ResultFormat(int divisor, String name) {
            assert (divisor != 0);
            this.divisor = divisor;
            this.name = name;
        }

        static {
            $VALUES = new ResultFormat[]{MILLISECONDS, MICROSECONDS, NANOSECONDS};
        }
    }
}

