/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.serialization.pb;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.box2d.proto.Box2D;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.jbox2d.serialization.JbDeserializer;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;

public class PbDeserializer
implements JbDeserializer {
    private JbDeserializer.ObjectListener listener = null;
    private UnsupportedListener ulistener = null;

    public PbDeserializer() {
    }

    public PbDeserializer(UnsupportedListener argListener) {
        this.ulistener = argListener;
    }

    public PbDeserializer(JbDeserializer.ObjectListener argObjectListner) {
        this.listener = argObjectListner;
    }

    public PbDeserializer(UnsupportedListener argListener, JbDeserializer.ObjectListener argObjectListner) {
        this.ulistener = argListener;
        this.listener = argObjectListner;
    }

    @Override
    public void setObjectListener(JbDeserializer.ObjectListener argListener) {
        this.listener = argListener;
    }

    @Override
    public void setUnsupportedListener(UnsupportedListener argListener) {
        this.ulistener = argListener;
    }

    private boolean isIndependentJoint(Box2D.PbJointType argType) {
        return argType != Box2D.PbJointType.GEAR && argType != Box2D.PbJointType.CONSTANT_VOLUME;
    }

    @Override
    public World deserializeWorld(InputStream argInput) throws IOException {
        Box2D.PbWorld world = Box2D.PbWorld.parseFrom(argInput);
        return this.deserializeWorld(world);
    }

    public World deserializeWorld(Box2D.PbWorld pbWorld) {
        Joint joint;
        Box2D.PbJoint pbJoint;
        int i;
        World world = new World(this.pbToVec(pbWorld.getGravity()));
        world.setAutoClearForces(pbWorld.getAutoClearForces());
        world.setContinuousPhysics(pbWorld.getContinuousPhysics());
        world.setWarmStarting(pbWorld.getWarmStarting());
        world.setSubStepping(pbWorld.getSubStepping());
        HashMap<Integer, Body> bodyMap = new HashMap<Integer, Body>();
        HashMap<Integer, Joint> jointMap = new HashMap<Integer, Joint>();
        for (int i2 = 0; i2 < pbWorld.getBodiesCount(); ++i2) {
            Box2D.PbBody pbBody = pbWorld.getBodies(i2);
            Body body = this.deserializeBody(world, pbBody);
            bodyMap.put(i2, body);
        }
        int cnt = 0;
        for (i = 0; i < pbWorld.getJointsCount(); ++i) {
            pbJoint = pbWorld.getJoints(i);
            if (!this.isIndependentJoint(pbJoint.getType())) continue;
            joint = this.deserializeJoint(world, pbJoint, bodyMap, jointMap);
            jointMap.put(cnt, joint);
            ++cnt;
        }
        for (i = 0; i < pbWorld.getJointsCount(); ++i) {
            pbJoint = pbWorld.getJoints(i);
            if (this.isIndependentJoint(pbJoint.getType())) continue;
            joint = this.deserializeJoint(world, pbJoint, bodyMap, jointMap);
            jointMap.put(cnt, joint);
            ++cnt;
        }
        if (this.listener != null && pbWorld.hasTag()) {
            this.listener.processWorld(world, pbWorld.getTag());
        }
        return world;
    }

    @Override
    public Body deserializeBody(World argWorld, InputStream argInput) throws IOException {
        Box2D.PbBody body = Box2D.PbBody.parseFrom(argInput);
        return this.deserializeBody(argWorld, body);
    }

    public Body deserializeBody(World argWorld, Box2D.PbBody argBody) {
        Box2D.PbBody b = argBody;
        BodyDef bd = new BodyDef();
        bd.position.set(this.pbToVec(b.getPosition()));
        bd.angle = b.getAngle();
        bd.linearDamping = b.getLinearDamping();
        bd.angularDamping = b.getAngularDamping();
        bd.gravityScale = b.getGravityScale();
        bd.bullet = b.getBullet();
        bd.allowSleep = b.getAllowSleep();
        bd.awake = b.getAwake();
        bd.active = b.getActive();
        bd.fixedRotation = b.getFixedRotation();
        switch (b.getType()) {
            case DYNAMIC: {
                bd.type = BodyType.DYNAMIC;
                break;
            }
            case KINEMATIC: {
                bd.type = BodyType.KINEMATIC;
                break;
            }
            case STATIC: {
                bd.type = BodyType.STATIC;
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown body type: " + argBody.getType(), UnsupportedObjectException.Type.BODY);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        Body body = argWorld.createBody(bd);
        for (int i = 0; i < b.getFixturesCount(); ++i) {
            this.deserializeFixture(body, b.getFixtures(i));
        }
        body.m_linearVelocity.set(this.pbToVec(b.getLinearVelocity()));
        body.m_angularVelocity = b.getAngularVelocity();
        if (this.listener != null && b.hasTag()) {
            this.listener.processBody(body, b.getTag());
        }
        return body;
    }

    @Override
    public Fixture deserializeFixture(Body argBody, InputStream argInput) throws IOException {
        Box2D.PbFixture fixture = Box2D.PbFixture.parseFrom(argInput);
        return this.deserializeFixture(argBody, fixture);
    }

    public Fixture deserializeFixture(Body argBody, Box2D.PbFixture argFixture) {
        Box2D.PbFixture f = argFixture;
        FixtureDef fd = new FixtureDef();
        fd.density = f.getDensity();
        fd.filter.categoryBits = f.getFilter().getCategoryBits();
        fd.filter.groupIndex = f.getFilter().getGroupIndex();
        fd.filter.maskBits = f.getFilter().getMaskBits();
        fd.friction = f.getFriction();
        fd.isSensor = f.getSensor();
        fd.restitution = f.getRestitution();
        fd.shape = this.deserializeShape(f.getShape());
        Fixture fixture = argBody.createFixture(fd);
        if (this.listener != null && f.hasTag()) {
            this.listener.processFixture(fixture, f.getTag());
        }
        return fixture;
    }

    @Override
    public Shape deserializeShape(InputStream argInput) throws IOException {
        Box2D.PbShape s = Box2D.PbShape.parseFrom(argInput);
        return this.deserializeShape(s);
    }

    public Shape deserializeShape(Box2D.PbShape argShape) {
        Box2D.PbShape s = argShape;
        CircleShape shape = null;
        switch (s.getType()) {
            case CIRCLE: {
                CircleShape c = new CircleShape();
                c.m_p.set(this.pbToVec(s.getCenter()));
                shape = c;
                break;
            }
            case POLYGON: {
                PolygonShape p = new PolygonShape();
                p.m_centroid.set(this.pbToVec(s.getCentroid()));
                p.m_count = s.getPointsCount();
                for (int i = 0; i < p.m_count; ++i) {
                    p.m_vertices[i].set(this.pbToVec(s.getPoints(i)));
                    p.m_normals[i].set(this.pbToVec(s.getNormals(i)));
                }
                shape = p;
                break;
            }
            case EDGE: {
                EdgeShape edge = new EdgeShape();
                edge.m_vertex0.set(this.pbToVec(s.getV0()));
                edge.m_vertex1.set(this.pbToVec(s.getV1()));
                edge.m_vertex2.set(this.pbToVec(s.getV2()));
                edge.m_vertex3.set(this.pbToVec(s.getV3()));
                edge.m_hasVertex0 = s.getHas0();
                edge.m_hasVertex3 = s.getHas3();
                shape = edge;
                break;
            }
            case CHAIN: {
                ChainShape chain = new ChainShape();
                chain.m_count = s.getPointsCount();
                chain.m_vertices = new Vec2[chain.m_count];
                for (int i = 0; i < chain.m_count; ++i) {
                    chain.m_vertices[i] = new Vec2(this.pbToVec(s.getPoints(i)));
                }
                chain.m_hasPrevVertex = s.getHas0();
                chain.m_hasNextVertex = s.getHas3();
                chain.m_prevVertex.set(this.pbToVec(s.getPrev()));
                chain.m_nextVertex.set(this.pbToVec(s.getNext()));
                shape = chain;
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown shape type: " + s.getType(), UnsupportedObjectException.Type.SHAPE);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        shape.m_radius = s.getRadius();
        if (this.listener != null && s.hasTag()) {
            this.listener.processShape((Shape)shape, s.getTag());
        }
        return shape;
    }

    @Override
    public Joint deserializeJoint(World argWorld, InputStream argInput, Map<Integer, Body> argBodyMap, Map<Integer, Joint> jointMap) throws IOException {
        Box2D.PbJoint joint = Box2D.PbJoint.parseFrom(argInput);
        return this.deserializeJoint(argWorld, joint, argBodyMap, jointMap);
    }

    public Joint deserializeJoint(World argWorld, Box2D.PbJoint joint, Map<Integer, Body> argBodyMap, Map<Integer, Joint> jointMap) {
        PrismaticJointDef jd = null;
        switch (joint.getType()) {
            case PRISMATIC: {
                PrismaticJointDef def;
                jd = def = new PrismaticJointDef();
                def.enableLimit = joint.getEnableLimit();
                def.enableMotor = joint.getEnableMotor();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.localAxisA.set(this.pbToVec(joint.getLocalAxisA()));
                def.lowerTranslation = joint.getLowerLimit();
                def.maxMotorForce = joint.getMaxMotorForce();
                def.motorSpeed = joint.getMotorSpeed();
                def.referenceAngle = joint.getRefAngle();
                def.upperTranslation = joint.getUpperLimit();
                break;
            }
            case REVOLUTE: {
                PrismaticJointDef def;
                jd = def = new RevoluteJointDef();
                def.enableLimit = joint.getEnableLimit();
                def.enableMotor = joint.getEnableMotor();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.lowerAngle = joint.getLowerLimit();
                def.maxMotorTorque = joint.getMaxMotorTorque();
                def.motorSpeed = joint.getMotorSpeed();
                def.referenceAngle = joint.getRefAngle();
                def.upperAngle = joint.getUpperLimit();
                break;
            }
            case DISTANCE: {
                PrismaticJointDef def;
                jd = def = new DistanceJointDef();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.dampingRatio = joint.getDampingRatio();
                def.frequencyHz = joint.getFrequency();
                def.length = joint.getLength();
                break;
            }
            case PULLEY: {
                PrismaticJointDef def;
                jd = def = new PulleyJointDef();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.groundAnchorA.set(this.pbToVec(joint.getGroundAnchorA()));
                def.groundAnchorB.set(this.pbToVec(joint.getGroundAnchorB()));
                def.lengthA = joint.getLengthA();
                def.lengthB = joint.getLengthB();
                def.ratio = joint.getRatio();
                break;
            }
            case MOUSE: {
                PrismaticJointDef def;
                jd = def = new MouseJointDef();
                def.dampingRatio = joint.getDampingRatio();
                def.frequencyHz = joint.getFrequency();
                def.maxForce = joint.getMaxForce();
                def.target.set(this.pbToVec(joint.getTarget()));
                break;
            }
            case GEAR: {
                PrismaticJointDef def;
                jd = def = new GearJointDef();
                if (!jointMap.containsKey(joint.getJoint1())) {
                    throw new IllegalArgumentException("Index " + joint.getJoint1() + " is not present in the joint map.");
                }
                def.joint1 = jointMap.get(joint.getJoint1());
                if (!jointMap.containsKey(joint.getJoint2())) {
                    throw new IllegalArgumentException("Index " + joint.getJoint2() + " is not present in the joint map.");
                }
                def.joint2 = jointMap.get(joint.getJoint2());
                def.ratio = joint.getRatio();
                break;
            }
            case WHEEL: {
                PrismaticJointDef def;
                jd = def = new WheelJointDef();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.localAxisA.set(this.pbToVec(joint.getLocalAxisA()));
                def.enableMotor = joint.getEnableMotor();
                def.maxMotorTorque = joint.getMaxMotorTorque();
                def.motorSpeed = joint.getMotorSpeed();
                def.frequencyHz = joint.getFrequency();
                def.dampingRatio = joint.getDampingRatio();
                break;
            }
            case WELD: {
                PrismaticJointDef def;
                jd = def = new WeldJointDef();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.referenceAngle = joint.getRefAngle();
                def.frequencyHz = joint.getFrequency();
                def.dampingRatio = joint.getDampingRatio();
                break;
            }
            case FRICTION: {
                PrismaticJointDef def;
                jd = def = new FrictionJointDef();
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.maxForce = joint.getMaxForce();
                def.maxTorque = joint.getMaxTorque();
                break;
            }
            case ROPE: {
                RopeJointDef def = new RopeJointDef();
                jd = def;
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.maxLength = joint.getMaxLength();
                return null;
            }
            case CONSTANT_VOLUME: {
                PrismaticJointDef def;
                jd = def = new ConstantVolumeJointDef();
                def.dampingRatio = joint.getDampingRatio();
                def.frequencyHz = joint.getFrequency();
                if (joint.getBodiesCount() != joint.getJointsCount()) {
                    throw new IllegalArgumentException("Constant volume joint must have bodies and joints defined");
                }
                for (int i = 0; i < joint.getBodiesCount(); ++i) {
                    int body = joint.getBodies(i);
                    if (!argBodyMap.containsKey(body)) {
                        throw new IllegalArgumentException("Index " + body + " is not present in the body map");
                    }
                    int jointIndex = joint.getJoints(i);
                    if (!jointMap.containsKey(jointIndex)) {
                        throw new IllegalArgumentException("Index " + jointIndex + " is not present in the joint map");
                    }
                    Joint djoint = jointMap.get(jointIndex);
                    if (!(djoint instanceof DistanceJoint)) {
                        throw new IllegalArgumentException("Joints for constant volume joint must be distance joints");
                    }
                    def.addBodyAndJoint(argBodyMap.get(body), (DistanceJoint)djoint);
                }
                break;
            }
            case LINE: {
                UnsupportedObjectException e = new UnsupportedObjectException("Line joint no longer supported.", UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown joint type: " + joint.getType(), UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        jd.collideConnected = joint.getCollideConnected();
        if (!argBodyMap.containsKey(joint.getBodyA())) {
            throw new IllegalArgumentException("Index " + joint.getBodyA() + " is not present in the body map");
        }
        jd.bodyA = argBodyMap.get(joint.getBodyA());
        if (!argBodyMap.containsKey(joint.getBodyB())) {
            throw new IllegalArgumentException("Index " + joint.getBodyB() + " is not present in the body map");
        }
        jd.bodyB = argBodyMap.get(joint.getBodyB());
        Joint realJoint = argWorld.createJoint((JointDef)jd);
        if (this.listener != null && joint.hasTag()) {
            this.listener.processJoint(realJoint, joint.getTag());
        }
        return realJoint;
    }

    private Vec2 pbToVec(Box2D.PbVec2 argVec) {
        return new Vec2(argVec.getX(), argVec.getY());
    }
}

