/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PulleyJoint
extends Joint {
    public static final double MIN_PULLEY_LENGTH = 2.0;
    private final Vec2 m_groundAnchorA = new Vec2();
    private final Vec2 m_groundAnchorB = new Vec2();
    private double m_lengthA;
    private double m_lengthB;
    private final Vec2 m_localAnchorA = new Vec2();
    private final Vec2 m_localAnchorB = new Vec2();
    private double m_constant;
    private double m_ratio;
    private double m_impulse;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_uA = new Vec2();
    private final Vec2 m_uB = new Vec2();
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private double m_invMassA;
    private double m_invMassB;
    private double m_invIA;
    private double m_invIB;
    private double m_mass;

    protected PulleyJoint(IWorldPool argWorldPool, PulleyJointDef def) {
        super(argWorldPool, def);
        this.m_groundAnchorA.set(def.groundAnchorA);
        this.m_groundAnchorB.set(def.groundAnchorB);
        this.m_localAnchorA.set(def.localAnchorA);
        this.m_localAnchorB.set(def.localAnchorB);
        assert (def.ratio != 0.0);
        this.m_ratio = def.ratio;
        this.m_lengthA = def.lengthA;
        this.m_lengthB = def.lengthB;
        this.m_constant = def.lengthA + this.m_ratio * def.lengthB;
        this.m_impulse = 0.0;
    }

    public double getLengthA() {
        return this.m_lengthA;
    }

    public double getLengthB() {
        return this.m_lengthB;
    }

    public double getCurrentLengthA() {
        Vec2 p = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, p);
        p.subLocal(this.m_groundAnchorA);
        double length = p.length();
        this.pool.pushVec2(1);
        return length;
    }

    public double getCurrentLengthB() {
        Vec2 p = this.pool.popVec2();
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, p);
        p.subLocal(this.m_groundAnchorB);
        double length = p.length();
        this.pool.pushVec2(1);
        return length;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(double inv_dt, Vec2 argOut) {
        argOut.set(this.m_uB).mulLocal(this.m_impulse).mulLocal(inv_dt);
    }

    @Override
    public double getReactionTorque(double inv_dt) {
        return 0.0;
    }

    public Vec2 getGroundAnchorA() {
        return this.m_groundAnchorA;
    }

    public Vec2 getGroundAnchorB() {
        return this.m_groundAnchorB;
    }

    public double getLength1() {
        Vec2 p = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, p);
        p.subLocal(this.m_groundAnchorA);
        double len = p.length();
        this.pool.pushVec2(1);
        return len;
    }

    public double getLength2() {
        Vec2 p = this.pool.popVec2();
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, p);
        p.subLocal(this.m_groundAnchorB);
        double len = p.length();
        this.pool.pushVec2(1);
        return len;
    }

    public double getRatio() {
        return this.m_ratio;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 cA = data.positions[this.m_indexA].c;
        double aA = data.positions[this.m_indexA].a;
        Vec2 vA = data.velocities[this.m_indexA].v;
        double wA = data.velocities[this.m_indexA].w;
        Vec2 cB = data.positions[this.m_indexB].c;
        double aB = data.positions[this.m_indexB].a;
        Vec2 vB = data.velocities[this.m_indexB].v;
        double wB = data.velocities[this.m_indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        this.m_uA.set(cA).addLocal(this.m_rA).subLocal(this.m_groundAnchorA);
        this.m_uB.set(cB).addLocal(this.m_rB).subLocal(this.m_groundAnchorB);
        double lengthA = this.m_uA.length();
        double lengthB = this.m_uB.length();
        if (lengthA > 10.0 * Settings.linearSlop) {
            this.m_uA.mulLocal(1.0 / lengthA);
        } else {
            this.m_uA.setZero();
        }
        if (lengthB > 10.0 * Settings.linearSlop) {
            this.m_uB.mulLocal(1.0 / lengthB);
        } else {
            this.m_uB.setZero();
        }
        double ruA = Vec2.cross(this.m_rA, this.m_uA);
        double ruB = Vec2.cross(this.m_rB, this.m_uB);
        double mA = this.m_invMassA + this.m_invIA * ruA * ruA;
        double mB = this.m_invMassB + this.m_invIB * ruB * ruB;
        this.m_mass = mA + this.m_ratio * this.m_ratio * mB;
        if (this.m_mass > 0.0) {
            this.m_mass = 1.0 / this.m_mass;
        }
        if (data.step.warmStarting) {
            this.m_impulse *= data.step.dtRatio;
            Vec2 PA = this.pool.popVec2();
            Vec2 PB = this.pool.popVec2();
            PA.set(this.m_uA).mulLocal(-this.m_impulse);
            PB.set(this.m_uB).mulLocal(-this.m_ratio * this.m_impulse);
            vA.x += this.m_invMassA * PA.x;
            vA.y += this.m_invMassA * PA.y;
            wA += this.m_invIA * Vec2.cross(this.m_rA, PA);
            vB.x += this.m_invMassB * PB.x;
            vB.y += this.m_invMassB * PB.y;
            wB += this.m_invIB * Vec2.cross(this.m_rB, PB);
            this.pool.pushVec2(2);
        } else {
            this.m_impulse = 0.0;
        }
        data.velocities[this.m_indexA].w = wA;
        data.velocities[this.m_indexB].w = wB;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.m_indexA].v;
        double wA = data.velocities[this.m_indexA].w;
        Vec2 vB = data.velocities[this.m_indexB].v;
        double wB = data.velocities[this.m_indexB].w;
        Vec2 vpA = this.pool.popVec2();
        Vec2 vpB = this.pool.popVec2();
        Vec2 PA = this.pool.popVec2();
        Vec2 PB = this.pool.popVec2();
        Vec2.crossToOutUnsafe(wA, this.m_rA, vpA);
        vpA.addLocal(vA);
        Vec2.crossToOutUnsafe(wB, this.m_rB, vpB);
        vpB.addLocal(vB);
        double Cdot = -Vec2.dot(this.m_uA, vpA) - this.m_ratio * Vec2.dot(this.m_uB, vpB);
        double impulse = -this.m_mass * Cdot;
        this.m_impulse += impulse;
        PA.set(this.m_uA).mulLocal(-impulse);
        PB.set(this.m_uB).mulLocal(-this.m_ratio * impulse);
        vA.x += this.m_invMassA * PA.x;
        vA.y += this.m_invMassA * PA.y;
        vB.x += this.m_invMassB * PB.x;
        vB.y += this.m_invMassB * PB.y;
        data.velocities[this.m_indexA].w = wA += this.m_invIA * Vec2.cross(this.m_rA, PA);
        data.velocities[this.m_indexB].w = wB += this.m_invIB * Vec2.cross(this.m_rB, PB);
        this.pool.pushVec2(4);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 uA = this.pool.popVec2();
        Vec2 uB = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2 PA = this.pool.popVec2();
        Vec2 PB = this.pool.popVec2();
        Vec2 cA = data.positions[this.m_indexA].c;
        double aA = data.positions[this.m_indexA].a;
        Vec2 cB = data.positions[this.m_indexB].c;
        double aB = data.positions[this.m_indexB].a;
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.m_localAnchorA).subLocal(this.m_localCenterA), rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.m_localAnchorB).subLocal(this.m_localCenterB), rB);
        uA.set(cA).addLocal(rA).subLocal(this.m_groundAnchorA);
        uB.set(cB).addLocal(rB).subLocal(this.m_groundAnchorB);
        double lengthA = uA.length();
        double lengthB = uB.length();
        if (lengthA > 10.0 * Settings.linearSlop) {
            uA.mulLocal(1.0 / lengthA);
        } else {
            uA.setZero();
        }
        if (lengthB > 10.0 * Settings.linearSlop) {
            uB.mulLocal(1.0 / lengthB);
        } else {
            uB.setZero();
        }
        double ruA = Vec2.cross(rA, uA);
        double ruB = Vec2.cross(rB, uB);
        double mA = this.m_invMassA + this.m_invIA * ruA * ruA;
        double mB = this.m_invMassB + this.m_invIB * ruB * ruB;
        double mass = mA + this.m_ratio * this.m_ratio * mB;
        if (mass > 0.0) {
            mass = 1.0 / mass;
        }
        double C = this.m_constant - lengthA - this.m_ratio * lengthB;
        double linearError = MathUtils.abs(C);
        double impulse = -mass * C;
        PA.set(uA).mulLocal(-impulse);
        PB.set(uB).mulLocal(-this.m_ratio * impulse);
        cA.x += this.m_invMassA * PA.x;
        cA.y += this.m_invMassA * PA.y;
        cB.x += this.m_invMassB * PB.x;
        cB.y += this.m_invMassB * PB.y;
        data.positions[this.m_indexA].a = aA += this.m_invIA * Vec2.cross(rA, PA);
        data.positions[this.m_indexB].a = aB += this.m_invIB * Vec2.cross(rB, PB);
        this.pool.pushRot(2);
        this.pool.pushVec2(7);
        return linearError < Settings.linearSlop;
    }
}

