/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.arrays.IntArray;
import org.jbox2d.pooling.arrays.Vec2Array;

public class PolygonShape
extends Shape {
    private static final boolean m_debug = false;
    public final Vec2 m_centroid = new Vec2();
    public final Vec2[] m_vertices;
    public final Vec2[] m_normals;
    public int m_count = 0;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();
    private Transform poolt1 = new Transform();

    public PolygonShape() {
        super(ShapeType.POLYGON);
        int i;
        this.m_vertices = new Vec2[Settings.maxPolygonVertices];
        for (i = 0; i < this.m_vertices.length; ++i) {
            this.m_vertices[i] = new Vec2();
        }
        this.m_normals = new Vec2[Settings.maxPolygonVertices];
        for (i = 0; i < this.m_normals.length; ++i) {
            this.m_normals[i] = new Vec2();
        }
        this.setRadius(Settings.polygonRadius);
        this.m_centroid.setZero();
    }

    @Override
    public final Shape clone() {
        PolygonShape shape = new PolygonShape();
        shape.m_centroid.set(this.m_centroid);
        for (int i = 0; i < shape.m_normals.length; ++i) {
            shape.m_normals[i].set(this.m_normals[i]);
            shape.m_vertices[i].set(this.m_vertices[i]);
        }
        shape.setRadius(this.getRadius());
        shape.m_count = this.m_count;
        return shape;
    }

    public final void set(Vec2[] vertices, int count) {
        this.set(vertices, count, null, null);
    }

    public final void set(Vec2[] verts, int num, Vec2Array vecPool, IntArray intPool) {
        int ie;
        assert (3 <= num && num <= Settings.maxPolygonVertices);
        if (num < 3) {
            this.setAsBox(1.0, 1.0);
            return;
        }
        int n = MathUtils.min(num, Settings.maxPolygonVertices);
        Vec2[] ps = vecPool != null ? vecPool.get(Settings.maxPolygonVertices) : new Vec2[Settings.maxPolygonVertices];
        int tempCount = 0;
        for (int i = 0; i < n; ++i) {
            Vec2 v = verts[i];
            boolean unique = true;
            for (int j = 0; j < tempCount; ++j) {
                if (!(MathUtils.distanceSquared(v, ps[j]) < 0.5 * Settings.linearSlop)) continue;
                unique = false;
                break;
            }
            if (!unique) continue;
            ps[tempCount++] = v;
        }
        n = tempCount;
        if (n < 3) {
            assert (false);
            this.setAsBox(1.0, 1.0);
            return;
        }
        int i0 = 0;
        double x0 = ps[0].x;
        for (int i = 1; i < n; ++i) {
            double x = ps[i].x;
            if (!(x > x0) && (x != x0 || !(ps[i].y < ps[i0].y))) continue;
            i0 = i;
            x0 = x;
        }
        int[] hull = intPool != null ? intPool.get(Settings.maxPolygonVertices) : new int[Settings.maxPolygonVertices];
        int m = 0;
        int ih = i0;
        do {
            hull[m] = ih;
            ie = 0;
            for (int j = 1; j < n; ++j) {
                Vec2 v;
                if (ie == ih) {
                    ie = j;
                    continue;
                }
                Vec2 r = this.pool1.set(ps[ie]).subLocal(ps[hull[m]]);
                double c = Vec2.cross(r, v = this.pool2.set(ps[j]).subLocal(ps[hull[m]]));
                if (c < 0.0) {
                    ie = j;
                }
                if (c != 0.0 || !(v.lengthSquared() > r.lengthSquared())) continue;
                ie = j;
            }
            ++m;
            ih = ie;
        } while (ie != i0);
        this.m_count = m;
        for (int i = 0; i < this.m_count; ++i) {
            if (this.m_vertices[i] == null) {
                this.m_vertices[i] = new Vec2();
            }
            this.m_vertices[i].set(ps[hull[i]]);
        }
        Vec2 edge = this.pool1;
        for (int i = 0; i < this.m_count; ++i) {
            int i1 = i;
            int i2 = i + 1 < this.m_count ? i + 1 : 0;
            edge.set(this.m_vertices[i2]).subLocal(this.m_vertices[i1]);
            assert (edge.lengthSquared() > 1.4210854715202004E-14);
            Vec2.crossToOutUnsafe(edge, 1.0, this.m_normals[i]);
            this.m_normals[i].normalize();
        }
        this.computeCentroidToOut(this.m_vertices, this.m_count, this.m_centroid);
    }

    public final void setAsBox(double hx, double hy) {
        this.m_count = 4;
        this.m_vertices[0].set(-hx, -hy);
        this.m_vertices[1].set(hx, -hy);
        this.m_vertices[2].set(hx, hy);
        this.m_vertices[3].set(-hx, hy);
        this.m_normals[0].set(0.0, -1.0);
        this.m_normals[1].set(1.0, 0.0);
        this.m_normals[2].set(0.0, 1.0);
        this.m_normals[3].set(-1.0, 0.0);
        this.m_centroid.setZero();
    }

    public final void setAsBox(double hx, double hy, Vec2 center, double angle) {
        this.m_count = 4;
        this.m_vertices[0].set(-hx, -hy);
        this.m_vertices[1].set(hx, -hy);
        this.m_vertices[2].set(hx, hy);
        this.m_vertices[3].set(-hx, hy);
        this.m_normals[0].set(0.0, -1.0);
        this.m_normals[1].set(1.0, 0.0);
        this.m_normals[2].set(0.0, 1.0);
        this.m_normals[3].set(-1.0, 0.0);
        this.m_centroid.set(center);
        Transform xf = this.poolt1;
        xf.p.set(center);
        xf.q.set(angle);
        for (int i = 0; i < this.m_count; ++i) {
            Transform.mulToOut(xf, this.m_vertices[i], this.m_vertices[i]);
            Rot.mulToOut(xf.q, this.m_normals[i], this.m_normals[i]);
        }
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public final boolean testPoint(Transform xf, Vec2 p) {
        Rot xfq = xf.q;
        double tempx = p.x - xf.p.x;
        double tempy = p.y - xf.p.y;
        double pLocalx = xfq.c * tempx + xfq.s * tempy;
        double pLocaly = -xfq.s * tempx + xfq.c * tempy;
        for (int i = 0; i < this.m_count; ++i) {
            Vec2 vertex = this.m_vertices[i];
            Vec2 normal = this.m_normals[i];
            tempx = pLocalx - vertex.x;
            tempy = pLocaly - vertex.y;
            double dot = normal.x * tempx + normal.y * tempy;
            if (!(dot > 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void computeAABB(AABB aabb, Transform xf, int childIndex) {
        Vec2 lower = aabb.lowerBound;
        Vec2 upper = aabb.upperBound;
        Vec2 v1 = this.m_vertices[0];
        double xfqc = xf.q.c;
        double xfqs = xf.q.s;
        double xfpx = xf.p.x;
        double xfpy = xf.p.y;
        lower.x = xfqc * v1.x - xfqs * v1.y + xfpx;
        lower.y = xfqs * v1.x + xfqc * v1.y + xfpy;
        upper.x = lower.x;
        upper.y = lower.y;
        for (int i = 1; i < this.m_count; ++i) {
            Vec2 v2 = this.m_vertices[i];
            double vx = xfqc * v2.x - xfqs * v2.y + xfpx;
            double vy = xfqs * v2.x + xfqc * v2.y + xfpy;
            lower.x = lower.x < vx ? lower.x : vx;
            lower.y = lower.y < vy ? lower.y : vy;
            upper.x = upper.x > vx ? upper.x : vx;
            upper.y = upper.y > vy ? upper.y : vy;
        }
        lower.x -= this.m_radius;
        lower.y -= this.m_radius;
        upper.x += this.m_radius;
        upper.y += this.m_radius;
    }

    public final int getVertexCount() {
        return this.m_count;
    }

    public final Vec2 getVertex(int index) {
        assert (0 <= index && index < this.m_count);
        return this.m_vertices[index];
    }

    @Override
    public double computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        double distance;
        double xfqc = xf.q.c;
        double xfqs = xf.q.s;
        double tx = p.x - xf.p.x;
        double ty = p.y - xf.p.y;
        double pLocalx = xfqc * tx + xfqs * ty;
        double pLocaly = -xfqs * tx + xfqc * ty;
        double maxDistance = -1.7976931348623157E308;
        double normalForMaxDistanceX = pLocalx;
        double normalForMaxDistanceY = pLocaly;
        for (int i = 0; i < this.m_count; ++i) {
            Vec2 vertex = this.m_vertices[i];
            Vec2 normal = this.m_normals[i];
            tx = pLocalx - vertex.x;
            ty = pLocaly - vertex.y;
            double dot = normal.x * tx + normal.y * ty;
            if (!(dot > maxDistance)) continue;
            maxDistance = dot;
            normalForMaxDistanceX = normal.x;
            normalForMaxDistanceY = normal.y;
        }
        if (maxDistance > 0.0) {
            double minDistanceX = normalForMaxDistanceX;
            double minDistanceY = normalForMaxDistanceY;
            double minDistance2 = maxDistance * maxDistance;
            for (int i = 0; i < this.m_count; ++i) {
                Vec2 vertex = this.m_vertices[i];
                double distanceVecX = pLocalx - vertex.x;
                double distanceVecY = pLocaly - vertex.y;
                double distance2 = distanceVecX * distanceVecX + distanceVecY * distanceVecY;
                if (!(minDistance2 > distance2)) continue;
                minDistanceX = distanceVecX;
                minDistanceY = distanceVecY;
                minDistance2 = distance2;
            }
            distance = MathUtils.sqrt(minDistance2);
            normalOut.x = xfqc * minDistanceX - xfqs * minDistanceY;
            normalOut.y = xfqs * minDistanceX + xfqc * minDistanceY;
            normalOut.normalize();
        } else {
            distance = maxDistance;
            normalOut.x = xfqc * normalForMaxDistanceX - xfqs * normalForMaxDistanceY;
            normalOut.y = xfqs * normalForMaxDistanceX + xfqc * normalForMaxDistanceY;
        }
        return distance;
    }

    @Override
    public final boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        double xfqc = xf.q.c;
        double xfqs = xf.q.s;
        Vec2 xfp = xf.p;
        double tempx = input.p1.x - xfp.x;
        double tempy = input.p1.y - xfp.y;
        double p1x = xfqc * tempx + xfqs * tempy;
        double p1y = -xfqs * tempx + xfqc * tempy;
        tempx = input.p2.x - xfp.x;
        tempy = input.p2.y - xfp.y;
        double p2x = xfqc * tempx + xfqs * tempy;
        double p2y = -xfqs * tempx + xfqc * tempy;
        double dx = p2x - p1x;
        double dy = p2y - p1y;
        double lower = 0.0;
        double upper = input.maxFraction;
        int index = -1;
        for (int i = 0; i < this.m_count; ++i) {
            Vec2 normal = this.m_normals[i];
            Vec2 vertex = this.m_vertices[i];
            double tempxn = vertex.x - p1x;
            double tempyn = vertex.y - p1y;
            double numerator = normal.x * tempxn + normal.y * tempyn;
            double denominator = normal.x * dx + normal.y * dy;
            if (denominator == 0.0) {
                if (numerator < 0.0) {
                    return false;
                }
            } else if (denominator < 0.0 && numerator < lower * denominator) {
                lower = numerator / denominator;
                index = i;
            } else if (denominator > 0.0 && numerator < upper * denominator) {
                upper = numerator / denominator;
            }
            if (!(upper < lower)) continue;
            return false;
        }
        assert (0.0 <= lower && lower <= input.maxFraction);
        if (index >= 0) {
            output.fraction = lower;
            Vec2 normal = this.m_normals[index];
            Vec2 out = output.normal;
            out.x = xfqc * normal.x - xfqs * normal.y;
            out.y = xfqs * normal.x + xfqc * normal.y;
            return true;
        }
        return false;
    }

    public final void computeCentroidToOut(Vec2[] vs, int count, Vec2 out) {
        assert (count >= 3);
        out.set(0.0, 0.0);
        double area = 0.0;
        Vec2 pRef = this.pool1;
        pRef.setZero();
        Vec2 e1 = this.pool2;
        Vec2 e2 = this.pool3;
        double inv3 = 0.3333333432674408;
        for (int i = 0; i < count; ++i) {
            Vec2 p1 = pRef;
            Vec2 p2 = vs[i];
            Vec2 p3 = i + 1 < count ? vs[i + 1] : vs[0];
            e1.set(p2).subLocal(p1);
            e2.set(p3).subLocal(p1);
            double D = Vec2.cross(e1, e2);
            double triangleArea = 0.5 * D;
            area += triangleArea;
            e1.set(p1).addLocal(p2).addLocal(p3).mulLocal(triangleArea * 0.3333333432674408);
            out.addLocal(e1);
        }
        assert (area > 1.1920928955078125E-7);
        out.mulLocal(1.0 / area);
    }

    @Override
    public void computeMass(MassData massData, double density) {
        assert (this.m_count >= 3);
        Vec2 center = this.pool1;
        center.setZero();
        double area = 0.0;
        double I = 0.0;
        Vec2 s = this.pool2;
        s.setZero();
        for (int i = 0; i < this.m_count; ++i) {
            s.addLocal(this.m_vertices[i]);
        }
        s.mulLocal(1.0f / (float)this.m_count);
        double k_inv3 = 0.3333333432674408;
        Vec2 e1 = this.pool3;
        Vec2 e2 = this.pool4;
        for (int i = 0; i < this.m_count; ++i) {
            e1.set(this.m_vertices[i]).subLocal(s);
            e2.set(s).negateLocal().addLocal(i + 1 < this.m_count ? this.m_vertices[i + 1] : this.m_vertices[0]);
            double D = Vec2.cross(e1, e2);
            double triangleArea = 0.5 * D;
            area += triangleArea;
            center.x += triangleArea * 0.3333333432674408 * (e1.x + e2.x);
            center.y += triangleArea * 0.3333333432674408 * (e1.y + e2.y);
            double ex1 = e1.x;
            double ey1 = e1.y;
            double ex2 = e2.x;
            double ey2 = e2.y;
            double intx2 = ex1 * ex1 + ex2 * ex1 + ex2 * ex2;
            double inty2 = ey1 * ey1 + ey2 * ey1 + ey2 * ey2;
            I += 0.0833333358168602 * D * (intx2 + inty2);
        }
        massData.mass = density * area;
        assert (area > 1.1920928955078125E-7);
        center.mulLocal(1.0 / area);
        massData.center.set(center).addLocal(s);
        massData.I = I * density;
        massData.I += massData.mass * Vec2.dot(massData.center, massData.center);
    }

    public boolean validate() {
        for (int i = 0; i < this.m_count; ++i) {
            int i1 = i;
            int i2 = i < this.m_count - 1 ? i1 + 1 : 0;
            Vec2 p = this.m_vertices[i1];
            Vec2 e = this.pool1.set(this.m_vertices[i2]).subLocal(p);
            for (int j = 0; j < this.m_count; ++j) {
                Vec2 v;
                double c;
                if (j == i1 || j == i2 || !((c = Vec2.cross(e, v = this.pool2.set(this.m_vertices[j]).subLocal(p))) < 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getNormals() {
        return this.m_normals;
    }

    public Vec2 centroid(Transform xf) {
        return Transform.mul(xf, this.m_centroid);
    }

    public Vec2 centroidToOut(Transform xf, Vec2 out) {
        Transform.mulToOutUnsafe(xf, this.m_centroid, out);
        return out;
    }
}

