/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class EdgeShape
extends Shape {
    public final Vec2 m_vertex1 = new Vec2();
    public final Vec2 m_vertex2 = new Vec2();
    public final Vec2 m_vertex0 = new Vec2();
    public final Vec2 m_vertex3 = new Vec2();
    public boolean m_hasVertex0 = false;
    public boolean m_hasVertex3 = false;
    private final Vec2 normal = new Vec2();

    public EdgeShape() {
        super(ShapeType.EDGE);
        this.m_radius = Settings.polygonRadius;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    public void set(Vec2 v1, Vec2 v2) {
        this.m_vertex1.set(v1);
        this.m_vertex2.set(v2);
        this.m_hasVertex3 = false;
        this.m_hasVertex0 = false;
    }

    @Override
    public boolean testPoint(Transform xf, Vec2 p) {
        return false;
    }

    @Override
    public double computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        double d1;
        double xfqc = xf.q.c;
        double xfqs = xf.q.s;
        double xfpx = xf.p.x;
        double v1x = xfqc * this.m_vertex1.x - xfqs * this.m_vertex1.y + xfpx;
        double dx = p.x - v1x;
        double v2x = xfqc * this.m_vertex2.x - xfqs * this.m_vertex2.y + xfpx;
        double sx = v2x - v1x;
        double xfpy = xf.p.y;
        double v1y = xfqs * this.m_vertex1.x + xfqc * this.m_vertex1.y + xfpy;
        double dy = p.y - v1y;
        double v2y = xfqs * this.m_vertex2.x + xfqc * this.m_vertex2.y + xfpy;
        double sy = v2y - v1y;
        double ds = dx * sx + dy * sy;
        if (ds > 0.0) {
            double s2 = sx * sx + sy * sy;
            if (ds > s2) {
                dx = p.x - v2x;
                dy = p.y - v2y;
            } else {
                dx -= ds / s2 * sx;
                dy -= ds / s2 * sy;
            }
        }
        if ((d1 = MathUtils.sqrt(dx * dx + dy * dy)) > 0.0) {
            normalOut.x = 1.0 / d1 * dx;
            normalOut.y = 1.0 / d1 * dy;
        } else {
            normalOut.x = 0.0;
            normalOut.y = 0.0;
        }
        return d1;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        Vec2 v1 = this.m_vertex1;
        Vec2 v2 = this.m_vertex2;
        Rot xfq = xf.q;
        Vec2 xfp = xf.p;
        double tempx = input.p1.x - xfp.x;
        double tempy = input.p1.y - xfp.y;
        double p1x = xfq.c * tempx + xfq.s * tempy;
        double p1y = -xfq.s * tempx + xfq.c * tempy;
        tempx = input.p2.x - xfp.x;
        tempy = input.p2.y - xfp.y;
        double p2x = xfq.c * tempx + xfq.s * tempy;
        double p2y = -xfq.s * tempx + xfq.c * tempy;
        double dx = p2x - p1x;
        double dy = p2y - p1y;
        this.normal.x = v2.y - v1.y;
        this.normal.y = v1.x - v2.x;
        this.normal.normalize();
        double normalx = this.normal.x;
        double normaly = this.normal.y;
        tempx = v1.x - p1x;
        tempy = v1.y - p1y;
        double numerator = normalx * tempx + normaly * tempy;
        double denominator = normalx * dx + normaly * dy;
        if (denominator == 0.0) {
            return false;
        }
        double t = numerator / denominator;
        if (t < 0.0 || 1.0 < t) {
            return false;
        }
        double qx = p1x + t * dx;
        double qy = p1y + t * dy;
        double rx = v2.x - v1.x;
        double ry = v2.y - v1.y;
        double rr = rx * rx + ry * ry;
        if (rr == 0.0) {
            return false;
        }
        tempx = qx - v1.x;
        tempy = qy - v1.y;
        double s = (tempx * rx + tempy * ry) / rr;
        if (s < 0.0 || 1.0 < s) {
            return false;
        }
        output.fraction = t;
        if (numerator > 0.0) {
            output.normal.x = -xfq.c * this.normal.x + xfq.s * this.normal.y;
            output.normal.y = -xfq.s * this.normal.x - xfq.c * this.normal.y;
        } else {
            output.normal.x = xfq.c * this.normal.x - xfq.s * this.normal.y;
            output.normal.y = xfq.s * this.normal.x + xfq.c * this.normal.y;
        }
        return true;
    }

    @Override
    public void computeAABB(AABB aabb, Transform xf, int childIndex) {
        Vec2 lowerBound = aabb.lowerBound;
        Vec2 upperBound = aabb.upperBound;
        Rot xfq = xf.q;
        double v1x = xfq.c * this.m_vertex1.x - xfq.s * this.m_vertex1.y + xf.p.x;
        double v1y = xfq.s * this.m_vertex1.x + xfq.c * this.m_vertex1.y + xf.p.y;
        double v2x = xfq.c * this.m_vertex2.x - xfq.s * this.m_vertex2.y + xf.p.x;
        double v2y = xfq.s * this.m_vertex2.x + xfq.c * this.m_vertex2.y + xf.p.y;
        lowerBound.x = v1x < v2x ? v1x : v2x;
        lowerBound.y = v1y < v2y ? v1y : v2y;
        upperBound.x = v1x > v2x ? v1x : v2x;
        upperBound.y = v1y > v2y ? v1y : v2y;
        lowerBound.x -= this.m_radius;
        lowerBound.y -= this.m_radius;
        upperBound.x += this.m_radius;
        upperBound.y += this.m_radius;
    }

    @Override
    public void computeMass(MassData massData, double density) {
        massData.mass = 0.0;
        massData.center.set(this.m_vertex1).addLocal(this.m_vertex2).mulLocal(0.5);
        massData.I = 0.0;
    }

    @Override
    public Shape clone() {
        EdgeShape edge = new EdgeShape();
        edge.m_radius = this.m_radius;
        edge.m_hasVertex0 = this.m_hasVertex0;
        edge.m_hasVertex3 = this.m_hasVertex3;
        edge.m_vertex0.set(this.m_vertex0);
        edge.m_vertex1.set(this.m_vertex1);
        edge.m_vertex2.set(this.m_vertex2);
        edge.m_vertex3.set(this.m_vertex3);
        return edge;
    }
}

