/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import java.util.List;
import org.jbox2d.common.MathUtils;

public class Profile {
    private static final int LONG_AVG_NUMS = 20;
    private static final double LONG_FRACTION = (double)0.05f;
    private static final int SHORT_AVG_NUMS = 5;
    private static final double SHORT_FRACTION = (double)0.2f;
    public final ProfileEntry step = new ProfileEntry();
    public final ProfileEntry stepInit = new ProfileEntry();
    public final ProfileEntry collide = new ProfileEntry();
    public final ProfileEntry solveParticleSystem = new ProfileEntry();
    public final ProfileEntry solve = new ProfileEntry();
    public final ProfileEntry solveInit = new ProfileEntry();
    public final ProfileEntry solveVelocity = new ProfileEntry();
    public final ProfileEntry solvePosition = new ProfileEntry();
    public final ProfileEntry broadphase = new ProfileEntry();
    public final ProfileEntry solveTOI = new ProfileEntry();

    public void toDebugStrings(List<String> strings) {
        strings.add("Profile:");
        strings.add(" step: " + this.step);
        strings.add("  init: " + this.stepInit);
        strings.add("  collide: " + this.collide);
        strings.add("  particles: " + this.solveParticleSystem);
        strings.add("  solve: " + this.solve);
        strings.add("   solveInit: " + this.solveInit);
        strings.add("   solveVelocity: " + this.solveVelocity);
        strings.add("   solvePosition: " + this.solvePosition);
        strings.add("   broadphase: " + this.broadphase);
        strings.add("  solveTOI: " + this.solveTOI);
    }

    public static class ProfileEntry {
        double longAvg;
        double shortAvg;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double accum;

        public void record(double value) {
            this.longAvg = this.longAvg * 0.9499999992549419 + value * (double)0.05f;
            this.shortAvg = this.shortAvg * 0.7999999970197678 + value * (double)0.2f;
            this.min = MathUtils.min(value, this.min);
            this.max = MathUtils.max(value, this.max);
        }

        public void startAccum() {
            this.accum = 0.0;
        }

        public void accum(double value) {
            this.accum += value;
        }

        public void endAccum() {
            this.record(this.accum);
        }

        public String toString() {
            return String.format("%.2f (%.2f) [%.2f,%.2f]", this.shortAvg, this.longAvg, this.min, this.max);
        }
    }
}

