(ns process.monitor)

;; Thanks to Jason Wolfe for the idea and the code snippet "observe-graph"

(defn- update-stats [k old update]
  (let [oldstat (get old k {})]
    (->> update
     (reduce-kv #(assoc % %2 (%3 (get oldstat %2 0))) oldstat)
     (assoc old k))))

;; Todo: make update policy and stats configurable

(defn monitor-graph
  "Monitors the execution of a process graph and keeps basic statistics in an atom
   attached as metadata to the graph.

   Usage: (def graph-with-stats (monitor-graph process-graph-definition))

   Alpha, subject to change."

  [g]
  (let [monitor (atom {})]
    (with-meta
      (into {}
            (for [[k f] g]
              [k
               (with-meta
                 (fn [& m]
                   (let [v (apply f m)]
                     (swap! monitor (partial update-stats k)
                            (if (nil? v)
                              {:total inc :error inc}
                              {:total inc}))
                     v))
                 (meta f))]))
      {:monitor monitor})))
