(ns leiningen.new.labs-template
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "labs-template"))

(defn labs-template
  "Create a new Fractal Labs project"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             [".gitignore" (render ".gitignore")]
             ["project.clj" (render "project.clj")]
             ["README.md" (render "README.md")]
             ["src/{{sanitized}}/core.clj" (render "core.clj")]
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)])))
